## Histogram

### Overview

A histogram visualises the frequency or count of how many values fall in certain intervals. A histogram gives a good
overview of the data's distribution. An example usage of the histogram is to show what values are outliers to the rest
of the data.

For examples,
see [this report with histograms](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FCharts%2FHistogram).

### Data

#### Query Builder

Below we show a typical mapping on the Query Builder for a histogram.

![Histogram Query Builder](images/histogram-query-builder.png)

This example sets buckets (10 by default) on the horizontal axis of the chart, and shows as values the number of sales
of each respective interval.

To create a histogram with groups, meaning each bucket is broken down into the different categories, by adding an element in the _Group by_ field, for example, `Article`.

#### MDX Query

The following is an example of a valid MDX query for the histogram.

```
SELECT 
[Measures].[#Sales] ON 0
[Time].[Time].[Month] ON 1
FROM [Sales]
```

This next example shows a valid MDX query for a histogram containing groups.

```
SELECT 
[Measures].[#Sales] ON 0
[Time].[Time].[Month] ON 1
[Product].[Product].[Article].head(2) ON 2
FROM [Sales]
```

This produces the following tidy table.

|&nbsp;|Month<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Article<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|#Sales<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|:---|---:|
|0|2018 Jan|Personal|9|
|1|2018 Jan|Server|12|
|2|2018 Feb|Personal|6|
|...|...|...|...|
|111|2022 Aug|Server|_\<null>_|
|112|2022 Sep|Personal|_\<null>_|
|113|2022 Sep|Server|_\<null>_|

For this query, the histogram auto-maps `#Sales` to _Y-Axis_ and sets `Article` as groups, meaning each bucket is
broken down into the different articles.

### Configuration

Configure the options for the histogram in the _Chart_ tab. The following groups of options are available.

#### Mapping

The histogram expects a [tidy table](../../../tidyTable/TidyTable.md) with the following columns.

_Y-Axis_ \
This column contains the values to show in the histogram.

_Group by_ \
If you want to group the values into separate histograms, then you can set this mapping to a column that describes the
groups.

#### Appearance

_X-Axis_ \
See [how to configure the x-axis](../topics/Am4CategoryDateAxis.md).

The chart takes the value format for the buckets from the value column. If it doesn't have any, then it takes the
default formatter from the theme. To change the bucket format, you should add the [Set Format](../../../tidyTable/transformations/TransformationSetNumberFormat.md) transformation on
the column you map in _Y-Axis_.

_Y-Axis_ \
See [how to configure the y-axis](../topics/Am4ValueAxis.md).

_Histogram_ \
The settings in this group change the algorithm for making the buckets. The default histogram settings produce a
histogram that closely matches `.hist()` in R [1].

Additionally, 
- the histogram sorts the buckets based on the starting value of the bucket,
- the algorithm rounds the values, and the interval borders, to 6 decimal places before calculating the counts per bucket.

_Column series_ \
Map _Color_ to a column in the tidy table to configure the colors of the columns. See also this [page](../../../howto/Coloring.md) for different coloring methods.

The value in _Tooltip_ is the value
shown when hovering over the column when the _Chart Cursor_ is enabled.

_Legend_ \
See [how to configure the legend](../topics/Am4Legend.md).

_Value Labels_ \
See [how to configure value labels](../topics/Am4ValueLabels.md).

_Chart Cursor_ \
See [how to configure the chart cursor](../topics/Am4ChartCursor.md).

_Scrollbar_ \
See [how to configure scrollbars](../topics/Am4Scrollbar.md).

[1]: R Core Team (2021). R: A language and environment for statistical computing. R Foundation for Statistical
Computing, Vienna, Austria. URL https://www.R-project.org/.

_
