## Geo Map

### Overview

A GeoMap is a geographical map widget where data is represented by color-filled regions such as countries, provinces,
departments, etc. The full world map is displayed by default, but you can choose to just show a certain region, or
exclude regions.

The [GeoMap report](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FMaps%2FGeoMap)
contains examples of GeoMaps.

### Data

The GeoMap requires the regions' data to be in [ISO-2 codes](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements).

#### Query Builder
Below we show a typical mapping on the Query Builder for a GeoMap.

![Geo Map Query Builder](images/geomap-query-builder.png)

The region should contain the members containing
the `@Ic3iso2` [member property](../../../server/mdx/Member%20Custom%20Property.md), use
the filter icon (see image above, green icon) to display the list of available members that contain these properties.

#### MDX Query 

Below we show a typical MDX query for a GeoMap using the Sales cube. 

```
SELECT
   {[Measures].[Amount]} ON "builderMeasureForColor"
   [Geography].[Classification].[Country].allmembers ON "region"
FROM [Sales]
```

As for the Query Builder above, the region used on the MDX query should contain
the `@Ic3iso2` [member property](../../../server/mdx/Member%20Custom%20Property.md).

#### Table Definition

An example for a table definition for the Geo map is the following. 

| Country | Amount |
| :--- | ---: |
| CH | 200 |
| FR | 450 |
| ES | 350 |
| GB | 300 |

The table definition should contain the [ISO-2 codes](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements) for the regions. Note that provinces and departments are available as well (e.g., FR-30).

### Configuration

Configure the options for the GeoMap in the _Chart_ tab. The following groups of options are available.

#### Mapping

The GeoMap expects a [tidy table](../../../tidyTable/TidyTable.md) with the following columns:

_Region Column_ \
Contains the regions' column
with [ISO-2 codes](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements), where members
should have the `@Ic3iso2` [member property](../../../server/mdx/Member%20Custom%20Property.md).

_Region Column Click_ \
Contains the column used to fire the region-click event.

_Map_ \
The map displayed by the chart. Per default, the chart shows the full world map, but it allows also to show just a certain region or country and even a custom GeoJSON file.

#### Appearance

_Map Geometry_ \
'Map Projection' allows defining the projection of the map. The default is 'Miller', which gives a flat projection. 'Orthographic' gives a 3D projection of the map.

You can set the initial latitude, longitude and zoom in the map as follows. First, get the location and zoom that you want on the map in the widget. Then, click on the widget's top right menu and select _Set Zoom & Center_.

_Settings_ \
_Region tooltip_ allows to configure the tooltip for hovering the map regions.

With _Unmatched Regions Strategy_, you can choose to exclude regions without any values. To exclude specific regions from the map, you can use _Exclude Regions_.

With _Draggable_ and _Zoomable_, you can change how the user can interact with the map.

_Colors_ \
Select the color column in _Region Color Column_. The regions receive the colors that are in this column. See also this [page](../../../howto/Coloring.md) for different coloring methods.

Also, regions that do not have a color get the color in _Default Region Color_. This color is grey by default. You can change the background color of the map with _Background color (water)_. This is transparent by default.

### Best practices

#### Use an Ordinal Palette

It makes it easier to read data on a map if regions are colored by a gradient of colors with intensity depending on the region's value. You can use these transformations to do so:

- 'Numeric color' that creates a gradient interpolation of a certain color;
- 'Ordinal Color Palette' that matches colors according to the order of the values, e.g., worst > neutral > best;
- or even 'Conditional Color', that allows to create a specific expression that can return a gradient of colors.

_
