## Gauge Chart

### Overview

Use a gauge chart to show a single value. For examples,
see [the gauge example report](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FCharts%2FGauge).

### Data

#### Query Builder
Below we show a typical mapping on the Query Builder for a gauge chart.

![Gauge Query Builder](images/gauge-query-builder.png)

This example sets `#Customers` as the displayed value on the gauge.

#### MDX Query

A typical MDX query looks like

```
SELECT
    [Measures].[#Customers] ON 0
FROM [Sales]
```

#### Flat Table

An example of a flat table is the following

|Amount<br>`numeric`|
|:---|
|156000|

Then, map `Amount` to _Value_.

### Configuration

#### Mapping

The gauge chart expects a [tidy table](../../../tidyTable/TidyTable.md) of one row with the following column.

_Value_ \
The value to show on the gauge chart.

#### Appearance

_Hand_ \
Set the color of the hand in _Color_.

_Axis_ \
Always set the minimum and maximum to define the range of the axis.

If the labels are too crowded, then you can increase the _Min label distance_.

The _Axis Ranges_ field defines ranges for the axis. Find detailed information in this [section](#gauge-axis-ranges).

_Center Text_ \
Alter _Text_ to change the value in the center.

_Gauge_ \
Change the radius to make the chart smaller. This is useful when the gauge does not fit the charting area.


## Gauge Axis Ranges

### Explanation

In this editor you can define axis ranges using the JSON editor on the left. The expected JSON is a list of objects with
the following properties:

_color_ \
The color of the range. Leave empty for no color.

_start_ \
This number corresponds to the start of the range on the axis.

_end_ \
This number specifies the end of the range on the axis.

_label_ \
The name of the range. Leave empty to show no label.

### Theme Colors

You can select a color from the theme by returning the name of that color. If a color is a palette, you can append `.n` to the string to get the _n_-th position (replace `n` by a number). For example, returning `'default'` gives the default single color from the theme and returning `'default.3'` gives the fourth color of the default palette.

### Example

For example, the following JSON results in a red range named 'low', and a green range named 'high'

```json
[
  {
    "label": "low",
    "start": 0,
    "end": 50,
    "color": "red"
  },
  {
    "label": "high",
    "start": 50,
    "end": 100,
    "color": "green"
  }
]
```


_
