## Donut Chart

### Overview

A donut chart visualizes a set of label-value pairs as slices in a donut. Each slice represents the relative size of a
value with respect to the total, i.e., the full donut. It is commonly used for showing market shares, product usage,
time division or survey results. A donut chart has most narrative power when the slices are sorted from large to small.

For examples,
see [the donut example report](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FCharts%2FDonut%252FPie).
### Data

#### Query Builder

Below we show a typical mapping on the Query Builder for a donut chart.

![Donut Query Builder](images/donut-query-builder.png)

This example sets `Continent` as the donut slices, with `#Customers` as the values.

#### MDX Query

A typical MDX query for the donut chart has one measure on the 0 axis, and a set of members (e.g., a hierarchy, a level,
etc.) on the 1 axis. For example:

```
SELECT 
    [Measures].[Amount] ON 0
    [Geography].[Geography].[Continent] ON 1
FROM [Sales]
```

Once the MDX result is converted to a [tidy table](../../../tidyTable/TidyTable.md), there is no need to explicitly map
the columns _Category_, _Value_ and _Color_. The chart takes per default the first measure column as the _Value_ and
the first non-measure column as the _Category_. In the example above, the `Continent` level is used as the _Category_,
and the measure `Amount` as the _Value_.

#### Flat Table

When using flat tables (e.g., with embedded data source), the columns have to be explicitly mapped to the chart in 
_Chart_ > _Slices_. Using the data:

|Continent<br>`character`|Amount<br>`numeric`|
|:---|---:|
|Africa|114550|
|Asia|391200|
|Europe|1306300|
|North America|241900|
|Oceania|90900|
|South America|156000|

You'll have to map `Continent` to _Category_ and `Amount` to _Value_ to get a correctly specified donut chart.

### Configuration

Configure the options for the donut chart in the _Chart_ tab. The following groups of options are available.

#### Mapping
The donut chart expects a [tidy table](../../../tidyTable/TidyTable.md) with the following columns:

_Category_ \
Contains the labels for the slices.

_Values_ \
Contains the values that determine the size of each slice.

_Colors_ (optional) \
Contains the colors for each slice. If the chart has no colors, it generates them from the default palette. See also this [page](../../../howto/Coloring.md) for different coloring methods.

#### Appearance

_Slices_ \
In this setting group, you configure how the chart maps the columns to its visual components. See the
section [Query Builder](#query-builder) for a description of the possible mappings.

To modify the tooltip, edit the markdown expression in the _Tooltip_ field.

To sort the slices from large to small, use the transformation in _Transformations_ > _Table_ > _Sort_.

_Label_ \
Styling a donut chart can be difficult due to long labels not fitting in the charting area. Use _Max Width_,
_Overflow Type_ and _Align Labels_ to control the size of the labels. If still the labels do not fit in the charting
area, you can reduce the size of the donut.

Another solution is to combine the slices of small values into a single slice called 'Other'. This is done using the
transformation _Transformations_ > _Table_ > _Group to Other_. Use this transformation after sorting the slices, so that
the 'Other' slice is the last slice in the donut chart.

_Center Text_ \
Using _Text_, you can set the text that is displayed in the center of the donut. If the text is not centered properly,
you can move the text by adjusting _Vertical Shift_ and _Horizontal Shift_ which move the text relatively to its
starting position.

_Legend_ \
In this settings group, you can configure the positioning of the legend using _Legend Position_.

If your donut chart does not have labels, you might want to show the values of the slices next to the legend. This is
done by enabling the _Show Values_ setting.

_Donut_ \
Use _Inner Radius_ to control the size of the inner part of the donut. The donut chart can easily be converted to a pie
chart by setting _Inner Radius_ to zero.

The _Radius_ of the donut controls the size of the donut. Reducing the radius helps if labels do not fit in the charting
area.

To change the starting and ending points of your donut instead of having a closed circle, change _Start Angle_
and _End Angle_.

### Best Practices

#### Sorting & Group to Other

When combining a group of slices into one 'Other' slice (_Group to Other_), it is a visual best practice to first add
the _Sort_ transformation to order the slices, and then use the _Group to Other_ transformation. Otherwise, this new
'Other' slice risks being placed in another position other than the last one, which is the expected result.

_
