## Combo Chart

### Overview

The combo chart shows two numeric variables in the same chart. It visualises one variable as lines, and the other as
columns. The chart has two y-axes, one for each variable. These axes synchronize so that the user can compare the
relative difference between the two variables.

For examples, have a look
at [this](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FCharts%2FCombo)
report.

### Data

#### Query Builder

Below we show a typical mapping on the Query Builder for a combo chart.

![Combo Query Builder](images/combo-query-builder.png)

This example sets `Continent` on the horizontal axis of the chart, shows `#Sales` as the line series and `Amount` as the
column series of the combo chart.

#### MDX Query

The following example MDX query has two measures, one for the line and one for the column.

```
SELECT 
{[Measures].[#Sales], [Measures].[Amount]} on 0,
[Geography].[Geography].[Continent] on 1
FROM [Sales]
```

This query results in the following tidy table.

|&nbsp;|Continent<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|#Sales<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|---:|---:|
|0|Africa|355|€833,200|
|1|Asia|147|€391,200|
|2|Europe|1150|€5,240,550|
|3|North America|446|€2,030,300|
|4|Oceania|112|€363,600|
|5|South America|51|€156,000|

The combo chart automatically maps the x-axis, the line and the column. In this case, these are `Continent`, `#Sales` and `Amount` respectively. This table does not have any groups. If you do have them, then you can map that column to _Group by_.

### Configuration

Configure the options for the combo chart in the _Chart_ tab. The following groups of options are available.

#### Mapping

The combo chart expects a [tidy table](../../../tidyTable/TidyTable.md) with the following columns:

_X-Axis_ \
A column that contains the labels for the x-axis.

_Line_ \
A column that contains the values for the line.

_Column_ \
A column that contains the values for the columns in the chart.

_Group by_ \
Optional, add an extra dimension to compare the values against. This clusters columns and lines that have the same value in the column that is mapped here.

_Level_ \
This divides the axis into a different section for each unique value in this column, resulting in a hierarchy on the axis.
Note, this only works when the mapped column in _Axis_ is of type character.

#### Appearance

_X-Axis_ \
See [how to configure the x-axis](../topics/Am4CategoryDateAxis.md).

_Left y-axis_ \
This is the axis for the lines. See [how to configure a value axis](../topics/Am4ValueAxis.md).

_Right y-axis_ \
This is the axis for the columns.
See [how to configure a value axis](../topics/Am4ValueAxis.md).

_Line series_ \
_Color_ controls the colors of the line bullets. The first color in this
column, and in the group if grouped, determines the color for the line. If _Color_ is undefined, the chart uses the
colors from either the color property of _Group_ or from the default theme palette applied on the values in _Group_.
If _Group_ is unmapped, it takes the default theme color from the palette. See also this [page](../../../howto/Coloring.md) for different coloring methods.

The options _Hide Line Bullets_ hides the bullets by making them invisible.

In the option _Tooltip_, you configure the tooltip for hovering the line chart. To actually see the tooltip, the option
_Chart Cursor_ must be enabled. The background-color of the tooltip is the sames as the color of the bullet.

The line's smoothness can also be set on the _Smooth Line Method_ option.

_Column Series_ \
Map _Color_ to a column in the tidy table to configure the colors of the columns. The value in _Tooltip_ is the value
shown when hovering over the column when the _Chart Cursor_ is enabled. See also this [page](../../../howto/Coloring.md) for different coloring methods.

_Legend_ \
See [how to configure the legend](../topics/Am4Legend.md).

_Chart Cursor_ \
See [how to configure the chart cursor](../topics/Am4ChartCursor.md).

_Scrollbar_ \
See [how to configure scrollbars](../topics/Am4Scrollbar.md).

_
