## Filters

The following filters are available:

* [Buttons](ic3/filter/FilterButtons.md)
* [Checkboxes](ic3/filter/FilterCheckboxRadio.md)
* [Date Picker](ic3/filter/DatePicker.md)
* [Simple Dropdown](ic3/filter/FilterAutocomplete.md)
* [Large Dropdown](ic3/filter/FilterAutocompleteLazy.md)
* [Filter Panel](ic3/filter/FilterPanel.md)
* [Tree](ic3/filter/FilterTree.md)
* [Slider](ic3/filter/FilterSlider.md)
* [Switch](ic3/filter/FilterSwitch.md)

### Filter Widgets' Usages

Filter widgets can be used for:

- their [natural filtering purpose](#using-filter-widgets-for-filtering),
- but also for [defining a query's axis](#using-filter-widgets-for-defining-mdx-axes).

Find below how to configure these two usages.

### Using Filter Widgets for Filtering

The usual usage for filters is for a click on an item to behave as a `FILTERBY` on a query. For example, a column chart
showing the `Amount` per `Year`, being filtered by a selected country.

![Filter usage - filter](images/filterusage1.png)

To illustrate the steps on how to this set up:

- Create a [Buttons filter](ic3/filter/FilterButtons.md) listing countries
  and [name your filter](../interactions/Events.md#publishing-an-event) under _Selection_ > _Publish Selection_.
- Create a [Column chart](amCharts4/chart/AmCharts4RegularColumnChart.md) with `Year` as the axis
  and `Amount` as the values.
- [Apply the filter](../interactions/Events.md#subscribing-to-an-event) to the Column chart.

### Using Filter Widgets for Defining MDX Axes

Instead of listing members (countries, articles, years, etc.), you can create a list of either measures, dimensions or
other members in your data. The purpose of the filter widget is then not to filter, but change a query's axis on a
chart. For example, a column chart where its horizontal axis is determined by the selection of the filter.

![Filter usage - axis](images/filterusage2.png)

Check
the [live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FHow+To%2FFilters+for+MDX+Axis).

To illustrate the steps on how to this setup:

- Create a Buttons filter and change the _Query_ > _Data Source_ to *CSV (Table Definition)*. Define a list of items
  with their according MDX `uniqueName` (case-sensitive syntax), here levels of the Sales cube are used:

```
item,item@uniqueName
Continent,[Geography].[Geography].[Continent]
Article,[Product].[Article].[Article]
Customer Type,[Customer].[Customer].[Type]
```

- [Name your filter](../interactions/Events.md#publishing-an-event) under _Selection_ > _Publish Selection_, e.g., _
  dimension_.
- Create a Column chart with `#Sales` as the values and your filter event `dimension` as the axis.

Your chart's query will now change depending on the dimension selected.

Similarly, items can also be a list of measures:

```
item,item@uniqueName
Amount,[Measures].[Amount]
#Sales,[Measures].[#Sales]
Amount AVG,[Measures].[Amount AVG]
```

or, specific members of a dimension:

```
item,item@uniqueName
28 May,[Time].[Time].[day].[28 May 2021]
Last week of May,[Time].[Time].[day].[24 May 2021]:[Time].[Time].[day].[31 May 2021]
Month of May,"DESCENDANTS([Time].[Time].[month].[2021 May],1)"
```

Note that quotes should be used if values have delimiters (here commas) such as the example above. 'Month of May'
contains a comma within the `DESCENDANTS()` function. Or else, the CSV table will read three columns for that row.

Also, do not use spaces at the start and the end of the values, especially if you want them to use quoted fields.

_
