## Transformation: Shift Values

Use this transformation to move each value, so that its new row index equals its old row index + _Shift_. This means that if _Shift_ is positive, it moves values forwards, and if _Shift_ is negative, it moves values backwards. If the previous or next value does not exist, it is set to _\<null>_.

For example, we shift the _Columns_ `Amount` by `-2` to get the following table.

|&nbsp;|Quarter<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Amount-2<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|---:|---:|
|0|2018 Q1|€83,100|179350|
|1|2018 Q2|€102,400|_\<null>_|
|2|2018 Q3|€179,350|_\<null>_|

Or we can shift the `Amount` column forward by setting _Shift_ to `1` to get the following result.

|&nbsp;|Quarter<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Amount+1<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|---:|---:|
|0|2018 Q1|€83,100|_\<null>_|
|1|2018 Q2|€102,400|83100|
|2|2018 Q3|€179,350|102400|

The transformation does not shift properties. 



### See Also

[Modify Values](TransformationApplyFunction.md)

_