## Transformation: Rank

With the rank transformation, you can rank rows based on the values in a set of columns. Rank is similar to sort, except instead of sorting, it adds a column to the table with the sorting position of the row. Sorting on this ranked column is the same as using the sort transformation with the same arguments as the rank transformation. 

#### Example

We use population data for France over the decades 1980 till 2020. 

|&nbsp;|Country<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Year<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Population<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Increase<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Is 20th century<br><span style="font-weight:normal;color:gray">&lt;logical&gt;</span>|
|:---|:---|---:|---:|---:|:---|
|0|France|2020|65273511|3.2|false|
|1|France|2010|62879530|6.7|false|
|2|France|2000|59015096|5.4|true|
|3|France|1990|56666849|5.2|true|
|4|France|1980|53868009|_\<null>_|true|

With the settings below, we add a ranked column to the table that ranks the increase in population from largest to smallest. 

![img.png](images/rank-settings.png)

This adds the following column to the table.

|&nbsp;|rank<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|---:|
|0|3|
|1|0|
|2|1|
|3|2|
|4|4|

As you can see, sorting on this column sorts the table on 'Increase' in descending order. 

#### See Also

[Sort Table](TransformationSortTable.md)

_