## Transformation: Pivot Wider

You use the pivot wider transformation to transpose the row-values of a column to become columns of the table. This
transformation is the inverse of the [pivot longer](TransformationPivotLonger.md) transformation.

#### Example

Let's look at a snippet of the classic Box & Jenkins airline data. It describes the total international airline
passengers for each month. Note, we transformed the dataset so that we can showcase the pivot wider transformation.

|&nbsp;|Year<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Month<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Total<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|---:|:---|---:|
|0|1949|Jan|112|
|1|1949|Feb|118|
|2|1949|Mar|132|
|3|1950|Jan|115|
|4|1950|Feb|126|
|5|1950|Mar|141|

_Source: Box, G. E. P., Jenkins, G. M. and Reinsel, G. C. (1976) Time Series Analysis, Forecasting and Control. Third
Edition. Holden-Day. Series G._.

As you can see, we have the total for the months in Q1 for each year. This means that we can also display the table with
the months as columns. You can do this with the pivot wider transformation as follows.

![](images/pivot-wider-settings.png)

This results in the following table.

|&nbsp;|Year<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Total, Jan<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Total, Feb<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Total, Mar<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|---:|---:|---:|
|0|1949|112|118|132|
|1|1950|115|126|141|

### See Also

[Pivot Longer](TransformationPivotLonger.md)

_
