## Transformation: Pivot Longer

You use the pivot longer transformation to transpose columns to become rows of the table. This transformation is the
inverse of the [pivot wider](TransformationPivotWider.md) transformation.

#### Example

Let's look at a snippet of the classic Box & Jenkins airline data. It describes the total international airline
passengers for each month. We took a subsection for Q1.

|&nbsp;|Year<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Jan<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Feb<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Mar<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|---:|---:|---:|---:|
|0|1949|112|118|132|
|1|1950|115|126|141|

_Source: Box, G. E. P., Jenkins, G. M. and Reinsel, G. C. (1976) Time Series Analysis, Forecasting and Control. Third
Edition. Holden-Day. Series G._.

As you can see, the table has a column for each month. The months can also be modeled as rows, so that we get year &
month combinations. You can do this with the pivot wider transformation and the following settings.

![](images/pivot-longer-settings.png)

Note that we included all the month columns in the 'Columns to pivot'. The transformation has the following result.

|&nbsp;|Year<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Month<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Total<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|---:|:---|---:|
|0|1949|Jan|112|
|1|1949|Feb|118|
|2|1949|Mar|132|
|3|1950|Jan|115|
|4|1950|Feb|126|
|5|1950|Mar|141|

### See Also

[Pivot Wider](TransformationPivotWider.md)

_

