## Transformation: Histogram

The histogram transformation counts for each bucket the number of values that fall in that bucket. 

### Examples

We use the following input table.

|&nbsp;|Date<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Value<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|---:|
|0|2020-01-01|1|
|1|2020-01-02|12|
|2|2020-01-03|6|
|3|2020-01-04|9|
|4|2020-01-05|87|
|5|2020-01-06|45|

We use `Value` as 'Value column' with 5 buckets. The following table is the result of the transformation.

|&nbsp;|bucket<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|count<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|---:|
|0|1 - 18.2|4|
|1|18.2 - 35.4|0|
|2|35.4 - 52.6|1|
|3|52.6 - 69.8|0|
|4|69.8 - 87|1|

In the result, each row is a bucket with the bucket name, and the number of values that fall in that bucket. In the
first row, we see that there are four values that fall in the bucket '1 - 18.2'. In the second row there are zero values
that fall in '18.2 - 35.4'. In total, there are 5 rows because we used 5 buckets. The transformation automatically
calculates the start and end of each bucket with a linear increment.

### Best Practices

For making a histogram barchart, we recommend sorting the buckets in descending order. That way, the first bucket is the
first bar in the chart.

The transformation takes the value format for the buckets from the value column. If it doesn't have any, then it takes
the default formatter from the theme. To change the bucket format, you should add the [Set Format](TransformationSetNumberFormat.md)
transformation _before_ calculating the buckets.

### See Also

[Add Bucket Column](TransformationHistogramBuckets.md)

_