## Transformation: Cumulative Sum

Use this transformation to add a column that is the cumulative sum of another column. It is defined as follows. If x<sub>0</sub>, x<sub>1</sub>, …, x<sub>n</sub> are the values of the input column with _n_ rows, then the cumulative sum for row _i_ is x<sub>0</sub> + x<sub>1</sub> + … + x<sub>i</sub>. If you set a _Group By_ column, then the indices are within the groups. 

For example, we do a cumulative sum on the following table with _Columns_ set to `Amount` and _Group By_ set to `Category`.

|&nbsp;|Category<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Quarter<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|:---|---:|
|0|License|2018 Q1|€58,500|
|1|License|2018 Q2|€98,000|
|2|License|2018 Q3|€142,250|
|3|Support|2018 Q1|€24,600|
|4|Support|2018 Q2|€4,400|
|5|Support|2018 Q3|€37,100|

Then we get the following result.

|&nbsp;|Category<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Quarter<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Amount (cusum)<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|:---|---:|---:|
|0|License|2018 Q1|€58,500|58500|
|1|License|2018 Q2|€98,000|156500|
|2|License|2018 Q3|€142,250|298750|
|3|Support|2018 Q1|€24,600|24600|
|4|Support|2018 Q2|€4,400|29000|
|5|Support|2018 Q3|€37,100|66100|

Note that the transformation does not copy the properties (in this case, the formatting) of the input column.

### See Also

[Group By](TransformationGroupBy.md),
[Percentage of Total](TransformationPercentageOfTotal.md),
[Rank](TransformationRankValues.md)

_