## Transformation: Conditional Color

Use this transformation to generate colors based on the cell value of the column. You can add one or more rules to control the color for each cell. 

The value for each rule is formatted the same as the value in the column before applying the rule. For example, you can use `2020-01-01T10:00:20` as value when you want to compare date values. 

Leave the value empty to compare to `null` values in the column.

### Example

You have this table:

|&nbsp;|Name<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|#Licences<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|---:|
|0|Thistle Corp.|60|
|1|Petty morel Ltd.|12|
|2|Daisy Ltd.|126|
|3|Yellow birch Ltd.|13|

With the following transformation, you can color the `#Licenses` column. 

![img.png](images/conditional_color.png)

You get this result table:

|&nbsp;|Name<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|#Licences<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|---:|
|0|Thistle Corp.|<span style='color:#00d4ea'>&#9646;</span> 60|
|1|Petty morel Ltd.|12|
|2|Daisy Ltd.|<span style='color:#a188db'>&#9646;</span> 126|
|3|Yellow birch Ltd.|13|

As you can see, the values are colored according to the rules, where the first matching rule sets the color. In this example, the value `126` is purple because the first rule has priority over the second rule. 

### See Also

[Conditional Color JS](TransformationColorConditionalJS.md),
[Replace Nulls](TransformationReplaceNull.md),
[Clear Color](TransformationClearColor.md),
[Categorical Color](TransformationColorCategorical.md),
[Copy Column Color to Table](TransformationColorColumnToTable.md),
[Numeric Color](TransformationColorNumeric.md),
[Ordinal Color](TransformationColorOrdinal.md),
[Single Color](TransformationColorSingle.md),
[Set Missing Colors](TransformationSetMissingColor.md),
[Modify Color](TransformationTransformColor.md)

_