## Transformation: Conditional Color JS

Use this transformation to generate colors based on the cell value of the column. Note that the options _Palette_ and _Color_ don't do anything other than help you know what theme-colors are available. 

Use _Color Expression_ to make a function that returns colors based on a columns content. The current column, accessed by `$_currentColumn$`, is the column that is the input for the transformation. Read more about conditional expressions [here](../TidyTableColorRowExpr.md).

For example, if we have the following table,

|&nbsp;|Article<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Category<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|:---|---:|
|0|Personal|License|€148,250|
|1|Server|License|€7,132,000|
|2|Silver|Support|€575,200|
|3|Gold|Support|€530,600|
|4|Platinum|Support|€628,800|

and the following expression,

```typescript
if ('$_currentCell$' == 'Personal') {
  return 'green';
}

if (Math.log($Amount$) > 15) {
  return 'red';
}

return 'yellow';
```

then we get the following result if we set _Columns_ to `Article`.

|&nbsp;|Article<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Category<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|:---|---:|
|0|<span style='color:#98de72'>&#9646;</span> Personal|License|€148,250|
|1|<span style='color:#fc6e6d'>&#9646;</span> Server|License|€7,132,000|
|2|<span style='color:#efcd5a'>&#9646;</span> Silver|Support|€575,200|
|3|<span style='color:#efcd5a'>&#9646;</span> Gold|Support|€530,600|
|4|<span style='color:#efcd5a'>&#9646;</span> Platinum|Support|€628,800|

Note that the following formats are supported: `#nnn`, `#nnnnnn`, `rgb()`, `rgba()`, `hsl()`, `hsla()`, `color()`, as well as the names of the colors defined in your [theme](../../api/plugin/Theme.md).

### See Also

[Conditional Color](TransformationColorConditionalRule.md),
[Replace Nulls](TransformationReplaceNull.md),
[Clear Color](TransformationClearColor.md),
[Categorical Color](TransformationColorCategorical.md),
[Copy Column Color to Table](TransformationColorColumnToTable.md),
[Numeric Color](TransformationColorNumeric.md),
[Ordinal Color](TransformationColorOrdinal.md),
[Single Color](TransformationColorSingle.md),
[Set Missing Colors](TransformationSetMissingColor.md),
[Modify Color](TransformationTransformColor.md)

_
