## Transformation: Modify Values

With this transformation you can modify the values of a column using an expression. The following expressions are
available:

- Numeric: javascript that returns a number, e.g., `Math.round($value$/1000)*1000`.
- HTML: a markdown template that returns HTML code, e.g., `<span style='color: red'>$value$</span>`.
- Text (javascript): javascript that returns a string, e.g.,
  ``` 
  if ($value$ < 1000000) {
    return '$value.mean$';
  }
  return 'bar';
  ```
- Scale: scale expression that scales the values, e.g.,
  - a predefined scale expression using a `c.` function
  - min/max scaling: `($value$ - $value.min$) / ($value.max$ - $value.min$)`
  - standardization: `($value$ - $value.mean$) / $value.standardDeviation$`

- Text: template that returns text, e.g., `$axis$ - $value$ ($value.percent.formatPercent()$)` returns 'Africa - €833,200 (9.2%)'.

Use `$_currentColumn$` to reference the current column in the expression.

### See Also

[Add a Column](TransformationAddColumn.md),
[Add Property](TransformationAddProperty.md),
[Modify Values](TransformationApplyFunction.md),
[Set Type](TransformationSetType.md),
[Localize Values](TransformationTranslate.md),
[List to String](TransformationListToString.md)

_
