## Transformation: Add (Sub)Totals

You can add totals and sub-totals to the table result with the add total transformation. The total doesn't need to be a sum, it can also be any of the other [aggregation functions](TransformationGroupBy.md#Aggregation-functions). 

#### Example

We have the following financial data. 

|<b></b>|Account<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Period<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Revenue<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Cost<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Profit<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|:---|---:|---:|---:|
|0|Sales|Q1|10|6|4|
|1|Sales|Q2|5|4|1|
|2|Human resources|Q1|7|9|-2|
|3|Human resources|Q2|14|1|13|
|4|Development|Q1|4|4|0|
|5|Development|Q2|6|2|4|

We want to calculate the total revenue, cost and profit per account. We do that with the following settings.

![img.png](images/add-total-settings.png)

This results in the following table.

|&nbsp;|Account<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Period<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Revenue<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Cost<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Profit<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|:---|---:|---:|---:|
|0|Sales|Q1|10|6|4|
|1|Sales|Q2|5|4|1|
|2|**Total Sales**|&nbsp;|**15**|**10**|**5**|
|3|Human resources|Q1|7|9|-2|
|4|Human resources|Q2|14|1|13|
|5|**Total Human resources**|&nbsp;|**21**|**10**|**11**|
|6|Development|Q1|4|4|0|
|7|Development|Q2|6|2|4|
|8|**Total Development**|&nbsp;|**10**|**6**|**4**|

As you can see, we have the sub-totals for each account. We can add a total of all accounts by clearing the 'At level'
option.



### Aggregations in hierarchical data

Hierarchical aggregations do not consider child-nodes. With this pivottable,

<table>
    <tbody>
        <tr>
            <td colspan=2 rowspan=2>Product</td>
            <td >2018</td>
            <td ></td>
            <td >2019</td>
            <td ></td>
        </tr>
        <tr>
            <td ></td>
            <td >2018 Q1</td>
            <td ></td>
            <td >2019 Q1</td>
        </tr>
        <tr>
            <td >Support</td>
            <td ></td>
            <td >€92,900</td>
            <td >€24,600</td>
            <td >€193,200</td>
            <td >€39,400</td>
        </tr>
        <tr>
            <td ></td>
            <td >Platinum</td>
            <td >€14,400 </td>
            <td ></td>
            <td >€49,200</td>
            <td > €1,200 </td>
        </tr>
        <tr>
            <td ><b>Total</b></td>
            <td ></td>
            <td ><b>€92,900</b></td>
            <td ><b>€24,600</b></td>
            <td ><b>€193,200</b></td>
            <td ><b>€39,400</b></td>
        </tr>
    </tbody>
</table>

The added totals only use parent values.

### See Also

[Group By](TransformationGroupBy.md)

_
