## Transformation: Add Tooltip Property

This transformation adds tooltips on the cells in the Table widget.
It does this by adding a 'tooltip' property on the cells in the column. When the user hovers over a cell in the table, the user sees the tooltip with the content from the expression.

Note, this transformation is only available for the table & pivot table widget.

![img](images/hover_tooltip_cell.png)

#### Expression

We use an expression to generate the text for the tooltip. See [Text Expressions](../TidyTableTextExpression.md) for
more info. Below we show some examples for this table when the user hovers the cell with Silver.

|&nbsp;|Continent<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Article<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|#Articles<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|#Licences<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|:---|---:|---:|---:|
|0|Africa|Personal|<span style='color:rgb(224, 126, 96)'>&#9646;</span> €29,500|<span style='color:rgb(242, 204, 143)'>&#9646;</span> 1|<span style='color:rgb(225, 137, 101)'>&#9646;</span> 118|
|1|Africa|Server|<span style='color:rgb(230, 203, 162)'>&#9646;</span> €678,000|<span style='color:rgb(242, 204, 143)'>&#9646;</span> 1|<span style='color:rgb(230, 202, 161)'>&#9646;</span> 678|
|2|Africa|Silver|<span style='color:rgb(224, 129, 98)'>&#9646;</span> €50,800|<span style='color:rgb(242, 204, 143)'>&#9646;</span> 1|<span style='color:rgb(225, 138, 102)'>&#9646;</span> 127|
|3|Africa|Gold|<span style='color:rgb(225, 132, 99)'>&#9646;</span> €74,900|<span style='color:rgb(242, 204, 143)'>&#9646;</span> 1|<span style='color:rgb(225, 135, 101)'>&#9646;</span> 107|


- `$_currentCell$` evaluates to 'Silver'
- `$Article$ | $Amount$ ($Amount.percent.formatPercent()$)` evaluates to 'Silver | €50,800 (6.1%)'

### See Also

[Add Property](TransformationAddProperty.md)

_
