## Transformation: Add a Row

With this transformation you can add a row to the table. 


Use the 'Row Value Expression' to create the values for the new row. The expression returns a Javascript object (e.g., numeric, string, etc).

In 'Columns', you can set the current column that you can access in the expression editor with `$_currentColumn$`. As an example, 
if you have a table with different measures on its columns, and you'd like to add a row calculating the total sum for the `Amount` column and the average for other columns, 
select the measure columns on 'Columns' and the 'Row Value Expression' could be:
  ``` 
 if("$_currentColumn.caption$" == "Amount")
    return $_currentColumn.total$;

return $_currentColumn.average$
  ```

Use the 'Row Format Expression' to set the output format. This can also be a conditional expression as above.

### See Also

[Add a Column](TransformationAddColumn.md),
[Add Property](TransformationAddProperty.md), 
[Copy a Column](TransformationCopyColumn.md),
[Delete a Column](TransformationDeleteColumn.md)

_
