## Transformation: Add a Column

With this transformation you can add a column to the table. Use an expression to create the values for the new column. The following expressions are available. 

- Numeric: javascript that returns a number, e.g., `Math.round($value$/1000)*1000`.
- HTML: a markdown template that returns HTML code, e.g., `<span style='color: red'>$value$</span>`.
- Text (javascript): javascript that returns a string, e.g.,
  ``` 
  if ($value$ < 1000000) {
    return '$value.mean$';
  }
  return 'bar';
  ```
- Scale: scale expression that scales the values, e.g.,
    - min/max scaling: `($value$ - $value.min$) / ($value.max$ - $value.min$)`
    - standardization: `($value$ - $value.mean$) / $value.standardDeviation$`

  For the scale expression, the `c.` functions use the current column that you set in 'Current Column'. For example, another way to standardize the column _Amount_ is by setting it as the current column and using `c.scaleStandardize()` as the expression.

- Text: template that returns text, e.g., `$axis$ - $value$ ($value.percent.formatPercent()$)` returns 'Africa - €833,200 (9.2%)'.

In 'Current column', you can set the current column that you can access in the expression editor with `$_currentColumn$`. 

### See Also

[Add Property](TransformationAddProperty.md), 
[Copy a Column](TransformationCopyColumn.md),
[Delete a Column](TransformationDeleteColumn.md),
[Add a Row](TransformationAddRow.md)

_
