## Transformation: Rating Renderer

The rating renderer renders a column as a star rating:

![Rating renderer](images/rend-rating.png)

Check the [live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FTable+%26+Pivot+Table%2FTable+Cell+Renderers).

This transformation is assuming the values are positive. Should you have some negative values, you can change
the _Scale_ option using the `c.scaleMaxAbsolute()` function and use different colors in the cells.

The transformation uses the colors in the column to color the stars. If the cell does not have a color, it uses the
default `chartSingleColors` from the theme.

The _Scale_ option allows for changing how to scale the values on the interval `[0, 1]`. The value `0` means no stars, and `1` an all star rating.

You can also use the [Add Tooltip Property](TransformationAddTooltipProperty.md) transformation to show the values of the cell on hover (e.g. `$_currentCell$`).

### See Also

[Icon Renderer](TransfRendererIconSet.md),
[Link Renderer](TransfRendererCustom.md),
[Progress Bar Renderer](TransfRendererProgressBar.md),
[Rich Text Renderer](TransfRendererRichText.md),
[Spark Line Renderer](TransfRendererSparkline.md),
[HTML Renderer](TransfRendererHtml.md)

_