## Transformation: Icon Renderer

With this transformation you can render the cell-contents of a column as an icon:

![Icon renderer](images/rend-icon.png)

Check the [live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FTable+%26+Pivot+Table%2FTable+Cell+Renderers).

This transformation is assuming the values are positive. Should you have some negative values, you can change
the _Scale_ option using the `c.scaleMaxAbsolute()` function and use different colors in the cells.

The transformation uses the colors in the column to color the icon. If the cell does not have a color, it uses the
default `chartSingleColors` from the theme.

In _Scale of Icon_ and _Icon Angle_ you can set an expression that evaluates to a scale or an angle in degrees. This way, you can change the icon based on data. 

Use `$_currentColumn$` in _Text before Icon_ and _Text after Icon_ to reference the cell-value.

You can also use the [Add Tooltip Property](TransformationAddTooltipProperty.md) transformation to show the values of the cell on hover (e.g. `$_currentCell$`).

### See Also

[Link Renderer](TransfRendererCustom.md),
[Progress Bar Renderer](TransfRendererProgressBar.md),
[Rating Renderer](TransfRendererRating.md),
[Rich Text Renderer](TransfRendererRichText.md),
[Spark Line Renderer](TransfRendererSparkline.md),
[HTML Renderer](TransfRendererHtml.md)

_