Scale expressions are a special kind of [Javascript expressions](TidyTableJSExpr.md) that are
adding support for accessing a scaling function. This scaling function allows for shrinking or magnifying values
(e.g., normalizing values between 0 and 1) of one or more tidy table columns.

### Examples

A scaling expression is a regular **Javascript** numeric statement, so you're free to write any Javascript and access
the underlying table via data accessors. Check below for available scaling functions.

```
    ($amount$ - $amount.min$) / ($amount.max$ - $amount.min$)
```

The following is normalizing the values using the minimum and maximum of the tidy table instead of the
current column:

```
    c.scaleNormalize( $_table.min$, $_table.max$ )
```

If the table already has a total column or row you can remove them from the calculation using `_tableExclude`, taking two parameters, first the excluded column and second the excluded row. In our
example, we exclude the last row of the table :

```
    c.scaleNormalize( $_tableExclude([],[-1]).min$, $_tableExclude([],[-1]).max$ )
```
More examples are available on this [page](TidyTableDataAccessor.md).

#### Selected Column(s)

The scaling functions are applied to one or more columns available in the evaluation context. For example, when scaling
values for a `Progress Bar` cell renderer transformation, the current columns are the ones specified in the
transformation. You can access the current columns with `$_selectedColumns$`.

#### Scaling Function (c.)

The context parameter `c` is giving access to the list of scaling functions. Use the completion to check all the
available
functions.

    c.scaleNormalize()

##### c.scaleNormalize()

Normalize the column so that its values are on `[0, 1]`. For each value `x`, return `(x - x_min) / (x_max - x_min)`.

    scaleNormalize( min, max, value )

        min  : optional. the default value is column.min() 
        max  : optional. the default value is column.max() 
        value: optional. the default value is column.getValue( row )

Several examples:

    c.scaleNormalize()
        is returning: ( column.getValue( row ) - column.min() ) / ( column.max() - column.min() )

    c.scaleNormalize(0) 
        is returning: column.getValue( row ) / column.max()\

    c.scaleNormalize($_selectedColumns.min$, $_selectedColumns.max$)
        is normalizing the columns' values with the minimum and maximum of the columns you selected in the transformation. 

##### c.scaleStandardize()

Standardize the column. For each value `x`, return `(x - mean) / (stdev)`.

    c.scaleStandardize()

##### c.scaleMaxAbsolute()

Scale a numeric column so that its values are on `[-1, 1]`. For each value `x`, return `x / max(|x_1|, |x_2|, ..., |x_n|)`, where `x_1, x_2, ..., x_n` are the values of the column.

    c.scaleMaxAbsolute()

### Data Accessors

Within the expression, tidy table data is available via [Data Accessors](TidyTableDataAccessor.md).

Data accessors of scale expressions define a **row index**.

### Completion

Note that code completion is available within a data accessor `$$` using `CTRL-SPACE`.

### Null / Undefined

If a default value exists on the expression and you want to remove it, insert a single space character.
