Numeric expressions are [Javascript expressions](TidyTableJSExpr.md)  that can access the widget underlying data thanks
to the data
accessors. A data accessor is basically the name of a column of the query result table enclosed in `$$`.

#### Examples

The following is returning `1, -1, 0` according to the actual value of the column `amount`:

```
    $amount$ > 0 ? 1 : $amount$ < 0 ? -1 : 0
```

### Data Accessors

Within the expression, tidy table data is available via [Data Accessors](TidyTableDataAccessor.md).

### Completion

Note that code completion is available within a data accessor `$$` using `CTRL-SPACE`.

### Null / Undefined

If a default value exists on the expression and you want to remove it, insert a single space character.