## Glossary

This page explains the terms used across the documentation. 

### amCharts

The primary chart [library](https://www.amcharts.com/) used by icCube charts (e.g., column chart, pie chart, sankey, etc.).

### Aggregation

The aggregation type defines how the icCube engine is going to calculate the actual value of a measure across the
dimension members. For example, calculate the total of a sales amount for all the country in Europe. Typical
aggregations includes: sum, min, max, count, unique count, etc.

### Application Menu

An application menu consists of a menu and filters. The menu allows for opening dashboards and/or triggering some
actions (e.g., refresh dashboard, print dashboard, etc.). The filters are shared amongst all dashboards. Similarly to
dashboards, application menus can be published and shared via their permalink (aka., URL).

### Authentication

The process of identifying users by confirming who they say they are.

In a typical embedded scenario this process is performed by the host application that is responsible to pass the right
credentials to icCube. See [on-the-fly authorization](#on-the-fly-authorization) for more details.

### Authorization

The process of establishing the rights and privileges of a user.

The icCube authorization is based on roles. That is once a user has been authenticated it is attached to a role that
describes its rights and privileges.

In a typical embedded scenario this process is performed both by icCube and the host application.
See [on-the-fly authorization](#on-the-fly-authorization) for more details.

### Builder (Server)

The application used to create schemas.

### Build-Once-Use-Many

The idea to create dashboards using a set of widgets whose look is not hardcoded. Then if you decide to change in the
future how a given widget should look because for example the corporate design has been updated then you do not need to
go over all the dashboards using it to make the actual change. You can for example update colors, fonts, default chart
options, etc.

### Canvas

The blank sheet available in the dashboard editor to place widgets in.

### Constants

Constants defined in a dashboard are for defining initial values of [events](#events).

More details about constants can be found [here](../interactions/Constants.md).

### Custom Theme

A customer's theme that is extending icCube via a plugin.

### Custom Tidy Table Transformation

A customer 's tidy table transformation that is extending icCube via a plugin.

### Custom Widget

A customer's widget that is extending icCube via a plugin. The custom widget can re-use existing icCube widgets or be
totally new and dedicated to the customer own needs. Customers can add any type of widget: charts, maps, tables,
filters, etc.

### Dashboard

A dashboard (aka. report) is a Web page made of widgets used representing key performance indicators and relevant
business data in a visual and interactive way. Dashboards can be published and shared via their permalink (aka., URL)
and embedded into customer Web applications.

### Dashboard Console

The application used for creating and visualizing dashboards. Also known as dashboard editor and/or dashboard viewer.

### Dashboard Editor

The Web application used to create dashboards.

### Dashboard Viewer

The Web application used to visualize dashboards.

### Dashboard Permalink

The URL used to display a dashboard.

### Data Source (Dashboard)

The actual source of the data set fed as input of a widget. The main data source is the MDX data source connected to
icCube. Other data sources include SQL query, table embedded definition, etc.

### Data Source (Server)

A data source is the actual source of raw data from which facts and dimensions are built.

### Dimension

Similar to the way tables and columns are central to SQL, dimensions are the centerpieces of multidimensional
structures. They are mapping business models into language-specific concepts (e.g. a list of countries will be mapped as
a dimension). They are used for indexing (or categorizing) the facts (aka. measure).

### Embedded Dashboard

Customer Web applications can embed icCube dashboards that look like being part of the host application. From the end
user point of view, there is no difference between the customer application and the icCube dashboard. The host
application can establish a two-way communication channel with the dashboards to both send and receive information.

### Events

Interactive dashboards require some sort of communication between the widgets (e.g., a filter needs to notify interested
charts about the newly selected date to refresh themselves accordingly). This communication is performed using events.
An event is a piece of information sent and received via a publish-subscribe mechanism (e.g., sending events).

For example a chart could publish its selection, and a table could subscribe to this selection for displaying detailed
information about it.

More details about events can be found [here](../interactions/Events.md) and [here (dev.)](../api/plugin/Events.md).

### Facts

Also known as measures, the actual analyzed values/observations. They are indexed (or categorized) by dimensions.

### Filter

A widget that allows for selecting one or more values (e.g., dates, regions, etc.) used for filtering charts, tables,
etc.

### Gadget

A [gadget](../gadgets/Gadgets.md) is a widget with its query (and any other options/configuration) that can be added
to a dashboard. Note that a gadget can contain a group of widgets.

### Host Application

A customer Web application that is embedding icCube dashboards. From the end user point of view, there is no difference
between the customer application and the icCube dashboard. The host application can open dashboard and establish a
two-way communication channel with the dashboards to both send and receive information (e.g., sending events).

### Layout

A layout is the frame in which widgets can be added. A layout can be limited in size (e.g. A4, Letter, Mobile, etc),
be horizontally responsive, have margins, have a specific orientation (Portrait, Landscape), contain header/footer, etc.

The Desktop layout is vertically unlimited in size by default, and can be horizontally responsive. You can define your
custom layouts on your [theme](#theme).

### Material UI

Material UI is the Javascript library (following Material Design) used to build the icCube dashboard editor.

### MDX

MDX stands for 'Multi-Dimensional Expressions' and is a language used to perform calculations and analysis around
multidimensional structures

### MDX Data Source

A dashboard data source supporting MDX queries. The result of the query is converted to a tidy table.

### Measure

Also known as facts, the actual analyzed values/observations. They are indexed (or categorized) by dimensions.

### On-The-Fly Authorization

The icCube [authorization](#authorization) is based on roles. That is once a user has been authenticated it is attached
to a role that describes its rights and privileges. On-the-fly authorization (aka. Dynamic Authorization) allows for 
defining the actual content of the role when the user is connecting into icCube.

How this role definition is actually built depends on the host application requirements. This can be done fully in
icCube or with a mix of icCube and the host application involvements to keep the source of this definition in the
existing host application corporate authentication/authorization system.

### Plugin

Customers can extend icCube dashboards with their own plugins. A plugin consists of custom themes, widgets, tidy table
transformations, localizations, etc. Plugins are exposed to icCube as Webpack Modules that can be federated. Then,
icCube can be configured to load them at runtime.

### Schema

The icCube server is basically a container of cubes (or simply cubes for short). A cube consists of numeric facts,
called measures, which are categorized by dimensions. Within the server, cubes are organized into schemas that are a
collection of cubes, possibly sharing one or more dimensions. A schema is defined as an XML file.

### Shell

In the context of Webpack Module Federation, the icCube application shell is a Javascript application that can be
configured to load at run-time a bunch of plugins as required by the actual customer requirements.

### SQL Data Source

A dashboard data source supporting SQL queries. The result of the query is converted to a tidy table.

### (CSV) Table Definition Data Source

A dashboard data source that is defining right in the dashboard the actual input data of a widget as a CSV content.

### Theme

A theme is a preset package containing graphical appearance and functionality details used to customize the look of the
dashboards. Theme entities include but not limited to are: dashboard layouts, color palette, typography font and size, default data
formatter, default chart options, etc. A theme is actually a Javascript module packaged as a plugin.

### Tidy Table

A tidy table is named after the name "tidy data" (aka. long data) that is well-known in the data science world. Each
column of the table corresponds to a variable and each row to an observation.

| Country   | Year     | Population    |
| :---      | :---     |       ---:    |
| France    | 2020     | 65'273'511    |
| France    | 2010     | 62,879,530    |
| France    | 2000     | 59'015'096    |
| France    | 1990     | 56'666'849    |
| France    | 1980     | 53'868'009    |

A tidy table is created from a dataset received from a data source (e.g., MDX, SQL, ...), possibly transformed and then
fed as input of a widget (i.e., chart, table, filter, ...) for its actual rendering.

More details about tidy tables can be found [here](../tidyTable/TidyTable.md).

### Tidy Table Transformation

A tidy table transformation (or simply a transformation) allows for manipulating the content of a tidy table before it
is fed as input of a widget (i.e., chart, table, filter, etc.) to make it more appropriate and valuable for the sake
of reporting/analytics. At the same time they allow for performing on the client side any additional data processing
that was not possible on the actual source of data.

Typical example of transformations are: add/rename a column, sort a column, group-by, compute derived values
(total, rank, etc.), compute colors, etc.

### Webpack

icCube is using the well-known Javascript module bundler to build the Dashboards application that is running in a Web
browser.

### Webpack Module

In modular programming, developers break programs up into discrete chunks of functionality called a module. A module is
then basically a file that needs to be bundled altogether to create an application ready to run in a browser. icCube is
using Webpack as its module bundler.

### Webpack Module Federation

The Webpack Module Federation allows for dynamically bundle modules. In contrast to compile time, runtime module
federation allows icCube to load plugins (i.e., themes, widgets, localizations, etc.) that were unknown when the
application was built.

### Widget

A dashboard is made of [widgets](../widgets/Widgets.md) (aka. visual components) that display a piece of information.
Typical widgets are charts, maps, tables, filters, gauges, textual information, etc. New types of widgets can be defined
through a plugin.

### Widget Interaction

Widget interactions include selection, drilldown, drillthrough and events. Those interactions are typically firing
[events](#events) that allows widgets to communicate to each other: for example, a selection event will be used to
filter the content of another widget.

### Widget Gallery

The actual collection of widgets used by the icCube application shell. Those are all the widgets available when using
the "New Widget" menu: out-of-the box widgets plus any custom widget.

_







