### Using Python as Data Source

The icCube server does not support running Python scripts within the application, however, you can use the results of a
Python script within icCube. For this, you set up a Python web-server that serves the results of the script in CSV or
JSON format. In this page we will show you how.

#### Python

The Python script below serves a Pandas data-frame as a JSON and as a CSV.

```python
import gzip
import pandas as pd
from flask import make_response, Flask, jsonify
from flask_cors import CORS

app = Flask(__name__)
CORS(app)

# Result of your Python script
df = pd.DataFrame(data={'col1': [1, 2], 'col2': [3, 4]})

@app.route('/data.json')
def compress():
    content = gzip.compress(csv.to_json(orient='records').encode('utf8'), 5)
    response = make_response(content)
    response.headers['Content-length'] = len(content)
    response.headers['Content-Encoding'] = 'gzip'
    response.headers['Content-Type'] = 'application/json'
    return response


@app.route('/data.csv')
def compress_csv():
    content = gzip.compress(csv.to_csv().encode('utf8'), 5)
    response = make_response(content)
    response.headers['Content-length'] = len(content)
    response.headers['Content-Encoding'] = 'gzip'
    response.headers['Content-Type'] = 'text'
    return response


if __name__ == '__main__':
    app.run(debug=True)  # run our Flask app
```

You can run this script for testing purposes. Then, in the widget or in the builder, you select the HTTP CSV or HTTP
JSON as the datasource. Next, you fill in the link to where the Flask server is running. If you are debugging on your
machine, it looks like `http://127.0.0.1:5000/data.csv`. See the image below.

![img.png](../images/csv-http-example.png)

#### Production

To run Flask in production, please look at Flask's page https://flask.palletsprojects.com/en/2.0.x/tutorial/deploy/.

### Next Steps

In the Dashboards application, you can add parameters to the data-source URL, which you can then use in your Python
program for generating the data-frame. For example, `http://127.0.0.1:5000/data.csv?test=@{selTest}` sets the parameter
_test_ to the event value in _selTest_.

_
