## MDX Query

MDX is the multidimensional query language used by icCube to query its cube-like data models
(see our [MDX tutorial](../../server/mdx_tutorial/gentle_introduction.md)). A typical
MDX query looks like the following:

```
SELECT 
  [Measures].[Amount] ON 0
  [Time].[Time].[Year] ON 1
FROM [Sales]
```

This query displays the `Amount` sold for all `Years` and gives the following [tidy table](../tidyTable/TidyTable.md).

Result:

|     | Year<br>`<character>` | Amount<br>`<numeric>` | 
|:----|:----------------------|:----------------------|
| 0   | 2000                  | 14950                 | 
| 1   | 2001                  | 2600                  | 
| 2   | 2003                  | 13100                 | 
| ... |
| 20  | 2021                  | 22650                 | 
| 21  | 2022                  | 3650                  | 
| 22  | 2023                  | 1200                  | 

You can use code completion in the editor by pressing `CTRL-SPACE`. For example, typing `[` and then
pressing `CTRL-SPACE` shows the list of dimensions and hierarchies you can use.

### Multiple Axes and Measures

Another classic MDX query uses several measures and 3 axes.

```
SELECT 
  { [Measures].[Amount], [Measures].[#Sales] } ON 0
  [Time].[Time].[Year] ON 1
  [Geography].[Geography].[Continent] ON 2
FROM [Sales]
```

This query will show the following [tidy table](../tidyTable/TidyTable.md) result:

|     | Year<br>`<character>` | Continent<br>`<character>` | Amount<br>`<numeric>` | #Sales<br>`<numeric>` |
|:----|:----------------------|:---------------------------|:----------------------|:----------------------|
| 0   | 2000                  | Asia                       | 14950                 | 30                    |
| 1   | 2001                  | Asia                       | 2600                  | 52                    |
| 2   | 2001                  | Africa                     | 13100                 | 44                    |
| ... |
| 20  | 2021                  | Europe                     | 22650                 | 90                    |
| 21  | 2021                  | Europe                     | 3650                  | 123                   | 
| 22  | 2022                  | North America              | 1200                  | 187                   |

Each item (i.e., measures in our example) on the `axis 0` is added as a tidy table column. The following axes
(i.e., 1 and 2 in our example) are added as the first columns of the tidy table.

The rows of the tidy table are the result of the `crossjoin` of axis 1 and 2.

### NON EMPTY Keyword

You can add the `NON EMPTY` keyword in front of each axis to remove empty items across all other axes:

```
SELECT 
  { [Measures].[Amount], [Measures].[#Sales] } ON 0
  NON EMPTY [Time].[Time].[Year] ON 1
  NON EMPTY [Geography].[Geography].[Continent] ON 2
FROM [Sales]
```

### Member Properties

Adding member properties can be done using the [DimensionProperties](../../server/post_processing/DimensionProperties.md)
result post processor.

### Events

Widgets can fire [events](../interactions/Events.md) when a user interacts with them. You can use these events to filter
or change your query, so that the data used by the widget changes according to these interactions.

In order to use the value of those events within a query (or any other textual field), a special notation aka.
`Event Accessor` is required: `@{eventName...}`:

    @{eventName}              : retrieve the default (depending on the usage context) value of the event possibly empty
    @{eventName!defaultValue} : defines a default value to use if the event value is empty
    @{eventName:'some text'}  : if event exists, displays the string "some text" (without single quotes)
    @{eventName:asCaption}    : retrieve the caption of the event (you can use :caption as well)
    @{eventName:asMdx}        : retrieve the value of the event as a valid MDX statement
    @{eventName:asSet}        : similar to asMdx wrapping the value into {} is required

Find [here](../interactions/Events.md#event-accessors) the complete list of event accessors.

#### Example 1: Event as a Filter

Assuming an event called `year` has been fired in the dashboard, you can add the following
`FILTERBY` statement at the end of the query:

    SELECT 
      [Measures].[Amount] ON 0,
      [Time].[Time].[Year] ON 1
    FROM [Sales]
      FILTERBY @{year}

##### Optional Event

Event values are mandatory. That is, the query above will not be executed until there is a value for the event
`year`. To make an event **optional**, you can use `!` to define the value of the event until the event is actually
fired/published for example by a filter.

For example, `@{year!2021}` defines `2021` as the default value for the event. It uses the default value when the event
has not fired yet.

In particular,

- `@{eventName!∅}` the `FILTERBY` will be ignored, while the event is not fired. Check
  the [Neutral Element](../../server/mdx/Neutral%20Element.md) MDX documentation.
- `@{eventName!null}` the `FILTERBY` will _empty_ the query, while the event is not fired.

#### Example 2: Event within an Axis

An event can be used within a query's axis instead of using it on a `FILTERBY`. A typical query could then be:

```
    SELECT  
      [Measures].[Amount]} ON 0
      @{year} ON 1
      [Geography].[Geography].[Continent] ON 2
    FROM [Sales]
```

In particular, be cautious when using `asMdx`and `asSet` event accessors within axes as they don't behave the same way.
In fact, `asSet` will always wrap the value around curly brackets {} whether there was a single or multi selection;
while `asMdx` will retrieve the value of the event without {} if there was a single selection, and a set if there was a
multi selection.

Single selection:

![Event Filter - single](images/eventfilter-single.png)

Multi selection:

![Event Filter - multi](images/eventfilter-multi.png)

#### Example 3: SQL Filter filtering an MDX Query

An MDX query can contain an event coming from an SQL data source.

Create an [SQL filter](FilterSqlQuery.md) - name it for example `sqlfilter` under Interactions > Selection > Publish
Selection - and a widget with an MDX query (or using the Graphical Query Builder) as input data.

The MDX query should receive the members as MDX entities. To do so:

- on the SQL filter: create an `Add Property` transformation and configure it as follows:
    - select the corresponding column,
    - set 'Unique Name' as `Property Name`,
    - set 'Text' as `Expression Type`
    - insert the MDX syntax for the conversion of the SQL items into MDX unique names. If as
      the [SQL filter](FilterSqlQuery.md) example, the list of items is countries, then insert
      the [MDX Unique Name](../../server/mdx/UniqueName.md) accessor `[City].[Country - L].[$_currentCell$]`
      where `$_currentCell$` retrieves the value. Read more about text expressions on
      this [page](../tidyTable/TidyTableTextExpression.md).
- on the MDX query of your widget: add `FILTERBY @{sqlfilter:asMdx}` at the end of your statement. If you are using the
  Graphical Query Builder, then first convert it to an MDX query statement by clicking 'To Statement' > 'Update Query'.

Check the bottom left example on
this [dashboard](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FHow+To%2FSQL+%26+MDX+Filters+and+Tables)
for a live example.

#### Example 4: CSV Filter filtering an MDX Query

An MDX query can contain an event coming from a CSV data source.

Create a [CSV filter](FilterTableDefinitionQuery.md) and a widget with an MDX query (or using the Graphical Query
Builder) as input data.

The CSV Filter table definition should contain the member's [MDX Unique Name](../../server/mdx/UniqueName.md) with the
following syntax:

```
item,item@uniqueName
Continent,[Geography].[Geography].[Continent]
```

Note that `uniqueName` is a case-sensitive syntax.

The MDX query can then receive this filter as [example 1](#example-1-event-as-a-filter)
or [example 2](#example-2-event-within-an-axis).

Refer to this [page](bleDefinitionQuery.md) for more information on CSV Filter table definition.

### Using MDX functions

The required query result for a filter is a set of members. The example queries above use levels and hierarchies to
retrieve a set of members. However, you can also use more complex MDX statements to produce a set. Let's look at some
functions that generate sets of members.

- [TopCount](../../server/mdx/TopCount.md)
  `TopCount( [Time].[Time].[Year], 2, [Measures].[Amount] )`, the two years with the biggest amounts

- [BottomCount](../../server/mdx/BottomCount.md)
  `BottomCount( [Time].[Time].[Year], 2, [Measures].[Amount] )`, the two years with the smallest amounts

- [Order](../../server/mdx/Order.md)
  `Order( [Time].[Time].[Year].[Measures].[Amount], ASC )`, years sorted by Amount from small to big

- [Filter](../../server/mdx/Filter.md)
  `Filter( [Measures].[Amount] > 100 )`, only years with an amount greater than 100

- [NonEmpty](../../server/mdx/NonEmpty.md)
  `NonEmpty( [Time].[Time].[Year], [Measures].[Amount] )`, all years with an existing amount

- [IIF](../../server/mdx/Iif.md)
  `IIF( [Measures].[Amount] > 100, 'Perfect' , 'Can Improve'  )`, return either `Perfect` or `Can Improve` depending on
  the actual value of `Amount`

For more functions, check the [full documentation](../../server/mdx/index.md). For a more in-depth discussion of MDX queries and their concepts, have a look at our
[MDX Tutorial (Gentle Introduction)](../../server/mdx_tutorial/gentle_introduction.md)).

### Code Completion

You can use code completion in the editor by pressing `CTRL-SPACE`. For example, typing `[` and then
pressing `CTRL-SPACE` shows the list of dimensions and hierarchies you can use.

_

