## SQL Query (Filter)

The SQL data source allows for the input data of a filter to directly be the result of an SQL query.

Filters display a list of items. Each filter type can have its specific query syntax, find the queries for the following filters on the sections below:
- [SQL Query (Filter)](#sql-query-filter)
  - [Buttons, Checkbox, Dropdown and Slider](#buttons-checkbox-dropdown-and-slider)
  - [Tree Filter](#tree-filter)
  - [Date Picker](#date-picker)
  - [Events](#events)
- [See Also](#see-also)

Find how to apply these filters to your chart(s) on this [section](#events).

### Buttons, Checkbox, Dropdown and Slider

The definition is the usual SQL usual syntax. 

As an example the definition:

```
SELECT country FROM country;      
```

is creating the tidy table:

| country<br>`<character>`        |
| :---           |
| Afghanistan    |
| Algeria        |
| American Samoa |
| Angola         |

The list of members returned is the list returned by the SQL statement.

For more information on these different filters and their configurations, check their respective pages: 
- [Buttons](../widgets/ic3/filter/FilterButtons.md)
- [Checkboxes](../widgets/ic3/filter/FilterCheckboxRadio.md)
- [Simple Dropdown](../widgets/ic3/filter/FilterAutocomplete.md)
- [Slider](../widgets/ic3/filter/FilterSlider.md)


### Tree Filter

The tree filter with an SQL query as input data is not yet available.

### Date Picker

The date picker with an SQL query as input data is not yet available.

### Events

The filter publishes the [event](../interactions/Events.md) set in the interaction tab. This way, it can communicate with other widgets in the
dashboard and effectively filter their queries (or display event content).

A default event name is given to your filter widget, you may change it in _Interaction_ > _Selection_ > _Publish Selection_. 
It is recommended to use recognizable names, so you can easily use them later. For example, if your
filter is listing Years, name it `years`. 

To apply this filter to *all* widgets in your dashboard, go to the widget's menu (top right icon)
and click on `Add Event to Queries`.

To apply this filter to individual widgets please refer to the event section of the widget's query:

- [MDX](MdxQuery.md#events) (e.g., filtering the cells, generating the axis content)
- [SQL](SqlQuery.md#events) (e.g., generating the `WHERE` clause)


## See Also

See : 

- this [page](SqlQuery.md#example-2-sql-filter-filtering-an-sql-query) for an example on an SQL-filter filtering an SQL
  Query,
- this [page](MdxQuery.md#example-4-sql-filter-filtering-an-mdx-query) for an example on an SQL-filter filtering an MDX
  query.


_
