## MDX Query Builder (Filter)

Filters need data to build and display their content. To build the query for a filter's data, use the graphical query
builder that allows for drag&drop setup. This query editor opens by default when opening a filter. Below we show the
query builder for filters.

![img.png](images/builder-example-filter.png)

In the top of the editor, you have the 'Run' button to run the query and show the result in the bottom of the editor.
With the 'Datasource' button, you can change the source for the query. With 'To Statement', you can switch to the text
query editor.

On the left, you have the _Items_ mappable field where you can drag and drop hierarchies, levels and measures. These are
displayed on the right in a tree-like structure. You can expand the tree to find hierarchies, levels and measures, or
you can use the search bar on the top right of the widget editor. Below the mappable fields, you can set the cube for
the query.

To view the query generated by the builder, you press 'To Statement' and then you press 'Update Query'. This shows the
query generated by the builder.

### Changing the order of levels

If you drag and drop multiple levels of the same hierarchy into the _Items_ field, usually when using
the [Tree filter](../widgets/ic3/filter/FilterTree.md), then they will join into a single chip. To change the order of
the
levels, click on the chip. In the screen that opens on the right, you can drag and drop the members
into the order you want.

![img.png](images/reorder-levels-in-builder.png)

### Adding MDX functions

After dragging and dropping a member into _Items_, you can click on the item to open a window with additional
information. Here, you can click on 'Add Function' to add an MDX function to the hierarchy or level. In the image below,
we added a top count on the `Country` set.

![img_1.png](images/mdx-function-example2.png)

If you do not find the function you want in the list of functions, then you can add your own function with the 'MDX Set'
function. For example, to reverse the items in the level, you use the `MDX Set` function with `reverse($set)` as value
in `MDX ($set)`. Note that `$set` is a placeholder for the set-expression.

For the complete list of possible MDX functions, we refer to
the [icCube MDX function reference](../../server/mdx/functions.md).

### Filtering the Query With Events

Filters can be filtered by other filters, see this [page](../howto/ConnectedFilters.md). If the dashboard has widgets
that generate events, then the query builder shows the event-names in the top of the tree.

![img.png](images/query-builder-events.png)

You can drag and drop these into the _Filter_ field if the filter allows for it.

_
