## MDX Query (Filter)

In general, the query result for a filter is a list of items. Here, we provide query examples for the following filters:

- [Buttons, Checkboxes, Dropdown, Slider](#buttons-checkbox-dropdown-and-slider)
- [Tree Filter](#tree-filter)
- [Date Picker](#date-picker)

Find how to connect these filters to other widgets in this [section](#events).

### Buttons, Checkbox, Dropdown and Slider

#### Query Builder

A typical query for buttons, checkboxes, dropdowns and sliders contains members as items. The example below gives a list
of years.

![Event filters](images/event-bcds.png)

#### MDX query

The MDX query usually contains a single axis:

```
SELECT 
  [Time].[Time].[Year] ON 0
FROM [Sales]
CELL PROPERTIES CELL_ORDINAL
```

This query displays the list of all years:

| Year<br>`<character>` | 
|:----------------------|
| 2020                  |
| 2021                  |
| 2022                  |
| 2023                  |

When no `measure` is being specified in a `SELECT` statement, the server is computing a result using the `default`
measure. For filters, we don't need any measure values in the query result. Using the
`CELL PROPERTIES CELL_ORDINAL` statement at the end of the query prevents the server from computing any actual value.
It only returns the list of members as selected on the axis.

Each filter has a page that describes how to configure it:

- [Buttons](../widgets/ic3/filter/FilterButtons.md)
- [Checkboxes](../widgets/ic3/filter/FilterCheckboxRadio.md)
- [Simple Dropdown](../widgets/ic3/filter/FilterAutocomplete.md)
- [Slider](../widgets/ic3/filter/FilterSlider.md)

### Tree Filter

#### Query Builder

The typical query for Tree Filters contains a list of member levels as items. By clicking on the items' chip you can add
the Hierarchize function. This converts the levels to a tree-like structure:

![Event Tree filters](images/event-tree.png)

Note that the levels should be of the same hierarchy.

#### MDX query

In MDX, a query for displaying a tree looks as follows:

```
SELECT 
  Descendants([Time].[Time].[Year]) ON 0
FROM [Sales]
CELL PROPERTIES CELL_ORDINAL
```

You can change the starting depth of the tree in _Chart_ > _Tree_ > _Expand/Collapse Depth_. For example, a value of 0
means that `Year` is expanded, and the levels below `Year` (Quarter, Month, Day) are collapsed.

Read more about Tree Filters and their configurations in the [Tree Filter](../widgets/ic3/filter/FilterTree.md) page.

### Date Picker

#### Query Builder

For the Date Picker, the query should contain the day level of a time hierarchy:

![Event Date Picker](images/event-date.png)

To see what datetime levels are available in the schema, you can click the green filter icon.

#### MDX query

In MDX, the query for the Date Picker filters should have a start and end date:

```
SELECT
    [Time].[Time].[Day].head(1) + [Time].[Time].[Day].tail(1) ON 0
FROM [Sales]
CELL PROPERTIES CELL_ORDINAL
```

This query gives the first and last available date of the `[Time].[Time].[Day]` level. It uses
the [Head()](../../server/mdx/Head.md) and [Tail()](../../server/mdx/Tail.md) functions.

Check the [Date Picker](../widgets/ic3/filter/DatePicker.md) page to learn more about the configuration and chart
settings.

### Writing advanced filter queries

#### Using MDX functions

The required query result for a filter is a set of members. The example queries above use levels and hierarchies to
retrieve a set of members. However, you can also use more complex MDX statements to produce a set. Let's look at some
functions that generate sets of members.

- [TopCount](../../server/mdx/TopCount.md)
  `TopCount( [Time].[Time].[Year], 2, [Measures].[Amount] )`, the two years with the biggest amounts

- [BottomCount](../../server/mdx/BottomCount.md)
  `BottomCount( [Time].[Time].[Year], 2, [Measures].[Amount] )`, the two years with the smallest amounts

- [Order](../../server/mdx/Order.md)
  `Order( [Time].[Time].[Year].[Measures].[Amount], ASC )`, years sorted by Amount from small to big

- [Filter](../../server/mdx/Filter.md)
  `Filter( [Measures].[Amount] > 100 )`, only years with an amount greater than 100

- [NonEmpty](../../server/mdx/NonEmpty.md)
  `NonEmpty( [Time].[Time].[Year], [Measures].[Amount] )`, all years with an existing amount

- [IIF](../../server/mdx/Iif.md)
  `IIF( [Measures].[Amount] > 100, 'Perfect' , 'Can Improve'  )`, return either `Perfect` or `Can Improve` depending on
  the actual value of `Amount`

For more functions, check the [full documentation](../../server/mdx/index.md). For a more in depth discussion
of MDX queries and its concepts, have a look at
our [MDX Tutorial (Gentle Introduction)](../../server/mdx_tutorial/gentle_introduction.md).

#### Code Completion

You can use code completion in the editor by pressing `CTRL-SPACE`. For example, typing `[` and then
pressing `CTRL-SPACE` shows the list of dimensions and hierarchies you can use.

### Events

The filter publishes the [event](../interactions/Events.md) set in the interaction tab. This way, it can communicate
with other widgets in the
dashboard and effectively filter their queries (or display event content).

A default event name is given to your filter widget, you may change it in _Interaction_ > _Selection_ > _Publish Selection_. 
It is recommended to use recognizable names, so you can easily use them later. For example, if your
filter is listing Years, name it `years`. 

To apply this filter to *all* widgets in your dashboard, go to the widget's menu (top right icon)
and click on _Add Event to Queries_.

To apply this filter to individual widgets please refer to the event section of the widget's query:

- [MDX](MdxQuery.md#events) (e.g., filtering the cells, generating the axis content)
- [SQL](SqlQuery.md#events) (e.g., generating the `WHERE` clause)

_

