## Drilldown MDX Expressions

With Drilldown MDX Expressions you can define custom ways of drilling down into the data. For example, we want users to drilldown from Year into the Continents when they expand or click the widget. The MDX expression for that is:

```
[Geography].[Geography].[Continent]
```

To drilldown again from Continent into another level, say Article, we use the following:

```
IIF( $member.level is [Time].[Time].[Year],
    [Geography].[Geography].[Continent]
    ,
IIF( $member.level is [Geography].[Geography].[Continent],
    [Product].[Product].[Article]
    ,
    ic3drilldownStop()
))
```
Use `ic3drilldownStop()`  at the end of the statement to prevent more drilldowns.

To order the members you are drilling down into, use the [`ORDER()`](../../server/mdx/Order.md) function. Note that you
can
also either use `$member.level` or `$member.hierarchy` in your expression. For example:

```
IIF( $member.hierarchy is [Time].[Time],
    ORDER([Geography].[Geography].[Continent], [Measures].[Amount], BDESC)
    ,
IIF( $member.hierarchy is [Geography].[Geography],
    ORDER([Product].[Product].[Article], [Measures].[Amount], BDESC)
    ,
    ic3drilldownStop()
))
```

To handle ragged or unbalanced hierarchies, where levels may have varying depths or missing members, 
you can use the following MDX expression to dynamically drill down into the next level of children, stopping at leaf nodes:
```
iif($member.isLeaf(), 

 ic3drilldownStop(), 
 
 Order(
    nonEmpty($member.children,[Measures].[Amount]), 
    [Measures].[Amount], 
    BDESC
  )
  
)
```

These are useful functions for drilling down or up into levels and members:

- [DrilldownLevel()](../../server/mdx/DrilldownLevel.md)
- [DrilldownLevelBottom()](../../server/mdx/DrilldownLevelBottom.md)
- [DrilldownLevelTop()](../../server/mdx/DrilldownLevelTop.md)
- [DrilldownMember()](../../server/mdx/DrilldownMember.md)
- [DrilldownMemberBottom()](../../server/mdx/DrilldownMemberBottom.md)
- [DrilldownMemberTop()](../../server/mdx/DrilldownMemberTop.md)
- [DrillUpLevel()](../../server/mdx/DrillUpLevel.md)
- [DrillUpMember()](../../server/mdx/DrillUpMember.md)

_
