## Widget Icons

A widget may contain icons in its header in certain cases. These icons are only visible if the header is active. 

![icons](images/icons.png)

Check the [live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FInteractivity%2FWidget+Icons).

It is possible to disable these icons in _Interactions_ > _Widget Icons_.

The following icon configurations are available on a widget's editor:

- [Disable Query Running](#disable-query-running)
- [Disable Query Filter](#disable-query-filter)
- [Disable Query Cell On Error](#disable-query-cell-on-error)
- [Disable Query Max Rows](#disable-query-max-rows)
- [Disable Drilldown](#disable-drilldown)
- [Disable Help](#disable-help)
- [Disable Interaction](#disable-interaction)


##### Disable Query Running

Disables the loading icon:  ![icon query running](images/icon-running.png) 

This icon is active by default and is visible when large queries are still running.


##### Disable Query Filter

Disables the filter icon:  ![icon query filter](images/icon-filter.png) 

This icon is active by default and is visible when a widget is being filtered by an [event](Events.md) or [selection](Selection.md).


##### Disable Query Cell On Error

Disables the error icon:  ![icon query error](images/icon-error.png) 

This icon is active by default and is visible when there is an error on a cell value, in all widget except the [Table](../widgets/ic3/chart/Table.md) and [Pivot Table](../widgets/ic3/chart/PivotTable.md).


##### Disable Query Max Rows

Disables the max row icon:  ![icon max rows](images/icon-maxrows.png) 

This icon is active by default and is visible when the query return more rows that the maximum row count the widget allows. For example, the [Table](../widgets/ic3/chart/Table.md) displays up to 100000 rows.


##### Disable Drilldown

Disables the back arrow icon when using [drilldowns](Drilldown.md):  ![icon max rows](images/icon-drilldown.png) 

This icon is active by default and is visible when the user has drilled down into the widget's data.


##### Disable Help

Disables the help icon:  ![icon help tooltip](images/icon-help-tooltip.png) (tooltip) or ![icon help dialog](images/icon-help-dialog.png) (dialog)

This icon is active by default and is visible when the _Box_ > _Help_ of a widget is active.


##### Disable Interaction

Disables the interaction icon:  ![icon selection](images/icon-interaction-selection.png) (selection) or ![icon drilldown](images/icon-interaction-drilldown.png) (drilldown)

This icon is active by default and is visible when both [selection](Selection.md) and [drilldown](Drilldown.md) are active.


_
