## Selection

Selection is a data navigation mechanism that allows to visually color or highlight a chart component upon clicking on this component.

Selection can be done on different widgets:
- [Selection on Tables and Pivot Tables](#selection-on-tables-and-pivot-tables), i.e., selecting rows, columns or cells
- [Selection on Charts](#selection-on-charts), i.e., selecting a bar of a [Bar chart](../widgets/amCharts4/chart/AmCharts4RegularBarChart.md), a slice of a [Donut](../widgets/amCharts4/chart/AmCharts4DonutChart.md), a node on a [Sankey diagram](../widgets/amCharts4/chart/AmCharts4SankeyDiagram.md), a country on a [Geo Map](../widgets/amCharts4/chart/AmCharts4GeoMap.md), etc.


Check
the [live chart selection examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FInteractivity%2FChart+Selection)
and [live pivot table selection examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FInteractivity%2FTable+%26+Pivot+Table+Selection)

To understand the difference between selection and events, check
this [section](#difference-between-selection-and-events).

### Publishing a Selection

On the Interactions tab of a widget's editor, the Selection group contains the `Publish Selection` field where the name of the selection can be defined.

### Subscribing to a Selection

On the Interactions tab of a widget's editor, the Selection group contains the `Subscribe Selection` field where the subscription to a selection can be defined. 

This means that when a selection is done on the selection-publisher widget, this selection will be colored/highlighted
on the subscribed widget. This can be seen as a 'synchronized' selection.

![Subscribing to a Selection](images/selection-subscribe.png)

### Selection on Tables and Pivot Tables

Find selection configuration under _Interaction_ > _Selection_.

To activate multi selection, set 'Multiple Selection' under _Interaction_ > _Selection_ > _Selection Mode_.

When selection is activated on Tables and Pivot Tables, the default _Selection Granularity_ is the 'Rows' selection. It is possible to change this field to set:
- 'Column' selection, 
- 'Columns' and 'Rows' selection: this means cell selection,
- or selection on a specific category of an axis, if there are more than one. For example, if you have both `Type` and `Continent` on an axis:

![Selection query](images/selection-query.png)

and would like to select only continents, then run the query and set the _Selection Granularity_ to `Continent`:

![Selection continent](images/selection-continent.png)

Now a click on a continent will select all rows of the table that contain that continent.


### Selection on Charts

Find selection configuration under _Interaction_ > _Selection_.

To activate multi selection, set 'Multiple Selection' under _Interaction_ > _Selection_ > _Selection Mode_.

#### Selection on serial charts

When selection is activated on serial charts such as bar, column, etc, the default _Selection Granularity_ is the 'Level,Group,Axis' selection, which means cell selection. Whether the chart has only one categorical axis defined as the following:
![Selection chart 1 axis](images/selection%20-%20chart%201%20axis.png)

here selecting 'Business', or all three _Level_ ,_Group_ and _Axis_ defined:
![Selection chart 3 axis](images/selection%20-%20chart%203%20axes.png)

here selecting '(Global North,Oceania,Business)', the default selection is a single cell, in this case a column.

If, in the 3-axes example above, the selection was set on:
- _Level_, a click would highlight all columns of the selected `Hemisphere`,
- _Group_, a click would highlight all columns of the selected `Continent`,
- _Axis_, a click would highlight all columns of the selected `Type`.

![Selection on charts](images/selection-col.png)


#### Selection on donuts, sankey, maps

Queries for donut, sankey and map widgets do not have more than one categorical axis. Therefore, selection granularity
does not exist, nor makes sense, in these cases. Selection is done on slices for donuts, on nodes for sankey diagrams
and on countries (usually) for maps.

Check
the [live examples (middle of page)](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FInteractivity%2FChart+Selection).

#### Selection with the chart cursor 

For widgets that have the _Chart_ > _Chart Cursor_ option, such as line, column, bubble, scatter, etc., it is possible to not only have individual clicks to generate a selection but also use the chart cursor to select an area which contains data points to be selected.

Configure 'Select-X', 'Select-Y' or 'Select-XY' under _Chart_ > _Chart Cursor_ > _Chart Cursor Behavior_.

The example below shows a 'Select-XY' behavior on a bubble chart.

![Selection bubbles](images/selection-bubbles.png)

Note that to use or display the selection, its syntax is the same as for [events](Events.md#event-accessors). On the
example above, `@{sel}` allows to access the selection and display it in the chart's title.

Check
a [live example (bottom of page)](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FInteractivity%2FChart+Selection)
of selection with a chart cursor.


### Difference between Selection and Events

Selection will:
- first, have a visual aspect to the click, the row, column or cell will be highlighted with a color defined on the theme.
- second, when the user makes a selection, all rows with the same values in the columns specified here get included in the selection.

Events will:
 - only be fired when clicking on the exact row/column/cell. On a row selection case, clicking on any cell will activate the selection for the full row.
 - will not highlight the click made. In this case, it is therefore advised to add the event name on the subscriber (widget receiving the event), read about event syntax [here](Events.md#event-accessors).

Check [live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FHow+To%2FPivot+Table+Selection+%26+Events)
showing the comparison between selections and events.

_
