## Filter Events

[Filters](../widgets/Filters.md) are widgets displaying lists of values (dates, countries, products, etc.). Filter
widgets filter other widgets upon a user's click by firing [events](Events.md).

![Filter Event](images/event-filter.png)

To illustrate the steps on how to set up filter events, let's take the example of
a [Buttons filter](../widgets/ic3/filter/FilterButtons.md) listing countries, that we would like to filter a chart (
line, column, geomap, etc.):
- Create your chart
- Create your buttons filter with countries as items
- On your filter's Interactions tab, set the event's name under _Selection_ > _Publish Selection_ to *country* (this is a best practice to have as soon as you create any filter)
- On your chart's Query tab, retrieve your event on the list of Events and drag & drop it into the Filter field.

![Event on Query](images/event-query.png)

- Optionally, add a dynamic title on your chart that will display the selected countries, check
  the [event syntax](Events.md#event-accessors).

Your chart is now filtered by the selected country of your filter. For multiple selection, enable it under _
Interaction_ > _Selection_ > _Selection Mode_.

To make your filter mandatory, i.e., for the chart not to display any data while no selection has been made on the
filter, go to the (subscriber) chart and click on your filter's chip and check the `mandatory event` box.

![Mandatory Event](images/event-mandatory.png)

### See Also

- [Events](Events.md) : general description of events.
- [Constants](Constants.md) : about defining initial values of events.

_
