## Events

Interactive dashboards require communication between widgets (e.g., a filter needs to notify charts about the newly
selected date to refresh themselves accordingly). This communication is performed using events.
An event is a piece of information sent and received via a publish-subscribe mechanism.

For example a map or a chart could publish its selection, and a table could subscribe to this selection for displaying
detailed information about it.

![Event](images/event-sel.png)

### Publishing an Event

Check the _Interaction_ tab in the widget editor.

When present, the _Selection_ group contains a field to define the name of the event containing the selection of the
widget.

When present, the _Events_ group contains one or more events published by the widget (e.g., row click for tables).

Several events related to the user and dashboard are automatically published; see this [page](./GlobalEvents.md)
for more details.

### Subscribing to an Event

A widget subscribes to an event using a dedicated syntax/notation for any of its option definition.
Indeed, any textual option field can consume an event. For example, we could decide to display the value of an
event in the title of a widget. The most common usage is to filter the data query with event values.

This can be done using the [MDX Graphical Query Builder](../query/QueryBuilderHelp.md) by adding an event to the filter
area. In the following picture, the MDX query is filtered by the value of the event `country`:

![Event Query Builder](images/event-qbuilder.png)

Or you can add the event value directly into the query definition. For example, the following MDX query is retrieving
some DVD rental information filtered by the event `country`:

    SELECT
        [Measures].[Amount] on 0
        [Time].[Time].[Year] on 1
    
    FROM [Sales]
    
    FILTERBY @{country}

#### Event Accessors

As seen above, to use the value of an event within a query (or any other textual field), a special notation
aka. `Event Accessor` is required: `@{eventName...}`:

    @{eventName}              : retrieve the default (depending on the usage context) value of the event possibly empty
    @{eventName!defaultValue} : defines a default value to use if the event value is empty
    @{eventName:'some text'}  : if event exists, displays the string "some text" (without single quotes)
    @{eventName:asCaption}    : retrieve the caption of the event (you can use :caption as well)

In particular, the use of the neutral element `∅` is possible, for example `@{eventName!∅}` and `@{eventName:asMdx!∅}`. This is useful when using the event on a `FILTERBY` or `WHERE` clause, where these would be ignored instead of waiting for the event. Read more on the [Neutral Element](../../server/mdx/Neutral%20Element.md) documentation.

**MDX specific**

    @{eventName:asMdx}        : retrieve the value of the event as a valid MDX statement
    @{eventName:asMdxCsv}     : retrieve the value of the event as a valid MDX statement to be used within a CSV table, i.e. replaces single by double quotes to keep the CSV format valid
    @{eventName:asKey}        : retrieve the key of the event (date/time are ISO 8601 formatted)
    @{eventName:asSet}        : similar to asMdx wrapping the value into {} is required

See [filtering an MDX Query](../query/MdxQuery.md#events) for more details.

**SQL specific**

    @{eventName:asSql}        : retrieve the value of the event as a valid SQL statement

See [filtering an SQL Query](../query/SqlQuery.md#events) for more details.

### Examples

#### MDX Query Filtering

The standard example for events is to filter the MDX query of a widget:

1. Create a [filter](../widgets/Filters.md) with countries as items
2. Publish this filters event: add the name *country* for this event under _Interaction_ > _Selection_ > _Publish
   Selection_
3. Create a [widget](../widgets/Widgets.md), say
   a [column chart](../widgets/amCharts4/chart/AmCharts4RegularColumnChart.md) with years as the axis and amount as the
   measure.
4. Subscribe to the *country* event: on the column chart's MDX Query Builder *Filter* field, drag and drop the *country*
   event.

#### Widget Title

Your dashboard contains an MDX filter listing countries, which event name is `country` and a given widget is subscribing
to this event. You would now like to have this widget's title to show the country(-ies) being selected. To do so, insert
on the widget's title field (_Chart_ > _Title_): *@{country}*.

#### Widget Title (Advanced)

You would now like to change the title of your widget to be dynamic with following rules:

- If no countries are selected, you would like this title to show: *Evolution of article sales (All Countries)*
- Upon selection of a country, you would like this title to show the selected country and a dash in between, i.e.,
  *Evolution of article sales - Spain*.

The syntax for your title should be: `Evolution of article sales @{country:' - '} @{country!(All Countries)}`

Note that if multiple countries are selected, the title will show: _Evolution of article sales - Spain, France, Brazil,
Japan_.

#### Others

Event value used to generate the axis of an MDX statement:
see [live example](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FHow+To%2FFilters+for+MDX+Axis).

Event value used to open a report:
see [live example](http://livedemo.iccube.com/icCube/report/viewer?ic3demo=ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FEmbedded+Dashboard%2FEmbedded+Dashboard).

### Dashboard Events Overview

Within a dashboard, you can have access to the list of available events via `Events` tab within the report options
editor. In this table you can view what event is published and subscribed by which widget(s), as well as if the event
is set as mandatory or not.

![Event Table](images/event-prop.png)

### See Also

- [Global Events](./GlobalEvents.md) : events automatically published in a dashboard
- [Filtering an MDX Query](../query/MdxQuery.md#events) (e.g., filtering the cells, generating the axis content)
- [Filtering an SQL Query](../query/SqlQuery.md#events) (e.g., generating the `WHERE` clause)
- [Constants](Constants.md) : about defining initial values of events.

_
