## Constants

Constants of a dashboard are initial values of [events](Events.md), i.e., when opening the dashboard.

Constants are useful inside embedded dashboards where the sources of events are not present (e.g., a country filter) and
where the dashboard containing the embedded dashboards forwards the events.
Defining constants in those embedded dashboards allows for introducing and working with those events. Check
the [example below](#example-constants-on-embedded-dashboards).

### Configuration

Open the dashboard settings (wheel on the left menu) and set the dashboard constants under _Properties_ > _Constants_.

![img.png](images/constants.png)

Several constants can be set, as soon as a constant is defined, a new line will be automatically added to set additional
ones.

Settings include:

_event_ \
Insert here the event's name. It should be the same name as the name defined on the _Publish Selection_
of your filter.

_name_ \
Name of the member to be selected by default.

_unique-name_ \
Unique name of the member to be selected by default. Depending on the event's data source, this could either mean
the [MDX Unique Name](../server/mdx/UniqueName.md), unique name on your SQL database or CSV file.

To define an empty event, leave both the _name_ and _unique-name_ blank.

### Example: constants on embedded dashboards

Check this [page](../howto/EmbeddedDashboardConstants.md) for an example on how to set an embedded dashboard with
constants.

### See Also

- [Events](Events.md) : general description of events.

_