## How To: Pivot Table Selection and Events

Selection is a data navigation mechanism that visually colors a pivot table's rows, columns or cells upon a click.
Configure selection settings under _Interaction_ > _Selection_.

Events are communication mechanisms that are made for sending or receiving information.

Check
the [live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FHow+To%2FFilters+for+MDX+Axis)
comparing selection and events.

### What's the difference between Selection & Events?

Selection will:

- first, have a visual aspect to the click, the row, column or cell will be highlighted with a color defined on the
  theme.
- second, when the user makes a selection, all rows with the same values in the columns specified here get included
  in the selection.

Events will:

- only be fired when clicking on the exact row/column/cell. For example, clicking on a row element (listed on the first
  column of the table) will fire the event, but not if clicking on a cell (measure); whereas on a row selection case,
  clicking on any cell will activate the selection for the full row.
- will not highlight the click made. In this case, it is therefore advised to add the event name on the subscriber
  (widget receiving the event). Read about event syntax [here](EventAccessors.md).

### See Also

See more general information on the [Events](../interactions/Events.md) and [Selection](../interactions/Selection.md)
pages.

