## How To: Event Accessors

To use the value of an event within a query (or any other textual field), a special notation
aka. `Event Accessor` is required: `@{eventName...}`:

    @{eventName}              : retrieve the default (depending on the usage context) value of the event possibly empty
    @{eventName!defaultValue} : defines a default value to use if the event value is empty
    @{eventName:'some text'}  : if event exists, displays the string "some text" (without single quotes)
    @{eventName:asCaption}    : retrieve the caption of the event (you can use :caption as well)

Check
these [live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FHow+To%2FEvent+Accessors)
on event accessors.

**MDX Specific**

    @{eventName:asMdx}        : retrieve the value of the event as a valid MDX statement
    @{eventName:asMdxCsv}     : retrieve the value of the event as a valid MDX statement, replacing quotes by double quotes
    @{eventName:asKey}        : retrieve the key of the event (date/time are ISO 8601 formatted)
    @{eventName:asSet}        : similar to asMdx wrapping the value into {} is required

See [filtering an MDX Query](../query/MdxQuery.md#events) for more details.

**SQL Specific**

    @{eventName:asSql}        : retrieve the value of the event as a valid SQL statement

See [filtering an SQL Query](../query/SqlQuery.md#events) for more details.

### See Also

See this [page](../interactions/Events.md) for general information on events.

_