## My First Dashboard

The purpose of this page is to help you understand how the application works and how to create your first dashboard. 

Go to the _Dashboard Editor_ and click on 'New Dashboard'. A popup with the following options appears.

![my first dashboard](images/my-first-dashboard.png)

Here you can select some defaults for your dashboard. For this dashboard, we select the Sales (LiveDemo) [schema](../reference/Glossary.md#schema), but you can choose any other schema as well. You can change
the theme ([definition](../reference/Glossary.md#theme) and [example](https://github.com/ic3-software/ic3-demo-plugin-theme)) and [layout](../layouts/Layouts.md), for now we'll use the
defaults.

### Adding a Widget

You can add a new widget with the 'New Widget' button. 
![new widget](images/new-widget.png)


In the menu that slides in, you can search and select
the widget you want to add to the dashboard.

![widget chooser](images/widget-chooser.png)

This widget chooser contains the out-of-the-box icCube widgets. If you
create [custom widgets](../reference/Glossary.md#custom-widget), they will appear in this chooser.

Select a widget. In the example below, we chose the line chart. Open the widget editor
by clicking on the settings icon (wheel icon on the left bar).

![my first widget](images/my-first-widget.png)

On the top part of the editor, you can use 'close' to close the editor, 'apply' to save the settings to the widget,
and 'rollback' to reset the editor to its opening state. Help buttons are available on various parts of the editor that
will allow to open the documentation on specific topics.

With the tabs, you can navigate between 
- chart, where you change widget-specific settings,
- query, where you add data to the widget,
- transformation, where you can transform the data, 
- interactions, where you can edit user-interactions, and
- box, where you can change settings about the box of the widget.

The first step in creating a widget is adding data to it. In the tab 'Query', you define the data that the widget will display (you can also use the Statement or another Data Source,
but we'll come back to that later). The list of available measures and hierarchies/levels is available on the
right-hand side to drag & drop into the according fields. You can read more about the query builder in the [Query Builder Help](../query/QueryBuilderHelp.md).

In the example below, we define a query with the measure `Amount` on the 'Y-Axis' and the level `Year` on the 'X-axis'.
We can view the result by clicking 'Run'. Click 'Apply' to save the changes and show the line chart.

![line chart](images/line-chart.png)

Now is a good time to save the dashboard. The Dashboard Viewer icon on the top app bar works as a preview display of the
dashboard. Then, click on the Visualize button to display the final dashboard result, i.e., what the end user will see.



### Adding a Filter

A filter is a widget that sends an event to other widgets. Choose a filter under 'New Widget' and add elements to it on
the Query Builder. Here, Continents were dragged & dropped into the _Items_ field.

![my first filter](images/my-first-filter.png)

A default name is given to your event (related to the data it's showing). You can change its name on the Interactions tab.

![event name](images/event-name.png)

To add an event to a widget, go to the Query Builder of the widget, in our case the line chart, drag & drop the event
into the Filter field.

![widget with filter](images/widget-with-filter.png)

When clicking on the filter's items, the widget will be filtered by the selection.

Optionally add the filter to the title of your widget, read more about interactions and its syntax on
this [page](../interactions/Interactions.md).

![title and event](images/title-and-event.png)


### Next Steps

You can add other widgets, you can check the [page](../widgets/Widgets.md) for a list of available widgets; or you can add filters to the dashboard, read more about them [here](../widgets/Filters.md). 

Widgets other than filters (i.e. charts, maps, etc) can also communicate with other widgets, check this [section](../interactions/ChartEvents.md) on how to configure those.

_
