## Configuration

The Javascript application is configured via a configuration file hosted in the `Web Docs` within the folder
`/ic3-reporting/app-local`. Since icCube v8.4.0, two types of files are available:

- Javascript (`ic3report-config.js`)
- JSON5 (`ic3report-config.json5`)

Switching the type of file is done in the `icCube.xml` file. Activating the `JSON5` file is done as following:

```
<reportingComponentConfiguration>

        <configurationType>JSON5</configurationType>
```

while the `Javascript` version as following:

```
<reportingComponentConfiguration>

        <configurationType>JS</configurationType>

```

The `JSON5` is compliant with typical `Content-Security-Policy` that is preventing any Javascript evaluation.
The both files are eventually defining an `options` object. This page is describing the Javascript version
but the JSON5 is very much similar (see an example at the bottom).

## ic3report-config.js (Javascript)

This Javascript file contains the `ic3config` method where the `options` parameter can be set up.
Both the `mode` and `context` parameters allow for accessing some extra information (e.g., the name and
the role of the user) to perform ad-hoc configuration:

![ic3report-config.js](images/ic3report-config.png)

#### Loading Plugin(s)

The following is showing how to load the `amCharts4` plugin:

    options.plugins = options.plugins || [];

    options.plugins.push({
        url: "plugins/amcharts4/remoteEntry.js",
        scope: "amCharts4",
        module: "./PluginDefinition",
    });

The URL path is relative the `ic3-reporting/app/` folder. Should you want to host/deploy your own plugins
within the `app-local/plugins` folder, the configuration would be:

    options.plugins = options.plugins || [];

    options.plugins.push({
        url: "app-local/plugins/MyPlugin/remoteEntry.js",
        scope: "MyPlugin",
        module: "./PluginDefinition",
    });

You can find more details in the plugin development examples in GitHub.

#### DataSource / Timeout

The following is changing the default request processing timeout to 60 seconds:

    // GVI connection (i.e., MDX processing, report definitions, etc...) timeout.

    options.dataSource = options.dataSource || {};
    options.dataSource.timeoutS = 60;

#### Google Map API Key

The picture above shows that the `options` contains the Google Map API key:

    options.google = {
        region: "",
        key: "...",
        renderedDelayMS: 1000,
    }

#### Localization

Dashboard content localization can be added as follows:

    options.contentLocalizations = options.contentLocalizations || [];

    options.contentLocalizations.push(
       "ic3report-c-localization.csv"
    );

The `ic3report-c-localization.csv` file is located within the `app-local` folder.

New Dashboards application localization for adding a new language (and/or overriding existing localization)
can be added as follows:

    options.localizations = options.localizations || [];

    options.localizations.push(
       "ic3report-localization.csv"
    );

The `ic3report-localization.csv` file is located within the `app-local` folder.

An extra documentation folder for adding a new language (and/or overriding existing pages) can be added as follows:

  	options.appDocUrlEx = "doc";

The `doc` folder is located within the `app-local` folder. This folder is overriding the content of the
`Web Docs:ic3-reporting/doc` folder.

#### Editor Theme

The `options.defaultEditorThemeId` allows to define the editor theme to use. This is the `id` of a theme
as defined in a loaded plugin. If the referenced `id` cannot be found, then the default icCube editor theme
is being used.

#### Limits

The `options` is supporting an optional field `limits` that is defined as follows:

    export interface IReportingLimits {
    
        /**
         * Default: 1000.
         */
        lazySearchMaxRowCount?: number;

        /**
         * Default: 1000.
         */
        globalFilterMaxMemberCount?: number;
    
        /**
         * Limit on the rows of the tidy result to both prevent the server and the browser to process
         * too many items. Set to -1 to have no limit. Note that the server side is defining a limit as well.
         *
         * Use the template qualified id (i.e., plugin-id.widget-template-id) as keys
         * or "amCharts4" for overridding all amCharts 4 widgets.
         *
         * E.g.,
         *      amCharts4.AmCharts4DonutChart  = 100
         *      ic3.FilterButtons              = 1000
         *      ic3.Table                      = 100000
         *      ic3.PivotTable                 = 100000
         */
        tidyMaxRowCount?: Record<string, number>;

        /**
         * On editing mode defines a maximum number of rows for all widgets.
         *
         *  maxRowsOnEditing = Math.min( tidyMaxRowCountWhenEditing, tidyMaxRowCount )
         *
         *  default : 1000
         */
        tidyMaxRowCountOnEditing?: number;
    
        /**
         * On editing mode defines the timeout of queries (in seconds).
         *
         *  default : 5
         */
        tidyTimeoutOnEditing?: number;
        
    }

**tidyMaxRowCount**

This configuration limits the number of rows of the query result to both prevent the server and the browser
to process too many items. Set to -1 to have no limit. As the server side is defining a limit as well, -1 means
the reporting application does not request any special limit and the server configuration will be used instead.

Note this configuration overrides the value possibly defined in the widget template definition.

The server is computing the limit as following :

    max-row-count = min( tidyRowCount, tidyCellCount / cells-column-count)
    
    where cells-column-count : the number of tuples on the axis 0.
    where tidyRowCount       : min( server-tidyRowCount, reporting-tidyRowCount )

If an MDX query is using several axes with the `NON EMPTY` statement, then the actual row count might be much
lower than expected. This is because the whole processing of the query must be performed before determining the
`NON EMPTY` MDX tuples in each axis.

For example : 

    select
        non empty [Dates] * [Products]      on 0
        non empty [Countries] * [Customers] on 1
    from [Sales] where [Measures.[Amount]

The `axis 0` might contain `1'000` tuples before the `NON EMPTY` processing and therefore the server will decide
to limit the number of rows before the actual `NON EMPTY` is taking place to :

    min( 100'000, 1'000'000 / 1'000 ) => 1'000

Once all the cells have been computed, several empty tuples can now be removed from the `axis 0`; let's say 10
tuples remains meaning this limit could have been `100'000` but there was no way to know in advance.

If this is not enough you can **increase the cell count limits** on the server side; both the `tidyCellCountNE`
and the `tidyCellCount`. While processing the `NON EMPTY` cells, the following formula is used :

    max-row-count = min( tidyRowCount, tidyCellCountNE / cells-column-count)

Once the `NON EMPTY` cells have been computed, the following formula is used to generate the actual result 
with the `NON EMPTY` being applied :

    max-row-count = min( tidyRowCount, tidyCellCount / cells-column-count)

**Container Scale Down/Up**

The `options` is supporting an optional field `containerScaleUp` that is defined as follows : 

    export interface IContainerScaleUpOptions {

        retryCountMax: number;    // default: 6 retries
        retryDelayMS: number;     // default: 500ms

        activeInEditor?: true;

    }

This option determine the policy to adopt for failing requests when an icCube server is scaling up.

**Filters Autosave**

The following `options` control the state of the filters of a dashboard in the browser local storage :

    localStorageContentCompress?: boolean;       // default: true
    localStorageContentEvictionDays?: number;    // default: 15

Note activating the autosave is done via a theme (default value) and overridden within each report properties.
Autosaving is deactivated by default.

**Dashboards Application Validation**

Starting with icCube 9.0.1, dashboards that are not available because of access rights are removed from the
application menu. This option allows for reverting to the historic behavior (no check).

    disableDashboardsAppValidation? : true;

## ic3report-config.json5 (JSON5)

The JSON5 version is very much similar. It is simply defining the `options` object. As an example, the following
is configuring the Google options, the plugins to load and the datasource timeout to 60 seconds:

    {
        google: {
            region: "",
            key: "...",
            renderedDelayMS: 1000,
        },
        plugins: [
            {
                url: "plugins/amcharts4/remoteEntry.js",
                scope: "amCharts4",
                module: "./PluginDefinition",
            },
            {
                url: "app-local/plugins/MyPluginJS/remoteEntry.js",
                scope: "MyPluginJS",
                module: "./PluginDefinition",
            }
        ],
        // GVI connection (i.e., MDX processing, report definitions, etc...) timeout.
        dataSource: {
            timeoutS: 60
        },
    }

_
