## Release Notes

<hr/>

### 9.0.1

<hr/>

`General`

- Dashboards Application validation : dashboards that are not available because of access rights are removed
  from the application menu before rendering the menu.

`Configuration`

- Introduced the `IReportingOptions` configuration properties in the file `ic3report-config.js(on5)` :
  ```
  disableDashboardsAppValidation? : true;
  ```

`Google Maps`

- When the Maps service is unavailable, display a user-friendly message instead of an error.

`Bug Fixes`

- Now the theme defaults for the print expand options are applied.

<hr/>

### 9.0.0

<hr/>

**IMPORTANT** : The Dashboards application 9.0 requires an icCube server 9.0.

**IMPORTANT** : Refer to the `General` section below for more details about changes made to improve users experience
with large schemas and slow MDX requests.

**IMPORTANT** : All API code from 8.6.2 that was tagged `deprecated` has been removed. If you use deprecated code in
your own plugin, first migrate to the new methods suggested by its docstring.

`General`

- To improve users experience, widgets that are not visible will no longer send their MDX query unless needed
  (i.e., generates an initial event, auto-expand). Introduced the `IReportingOptions` configuration properties in
  the file `ic3report-config.js(on5)` :
  ```
  forceRenderOnInvisibleWidgets?   : boolean
  forceRunQueryOnInvisibleWidgets? : boolean
  widgetRunQueryOnVisibilityMS?    : number   -- default 350
  ```

- To improve users experience, only a limited number concurrent MDX queries are sent to the server (default is 3).
  Introduced the `IReportingOptions` configuration properties in the file `ic3report-config.js(on5)` :
  ```
  numberOfConcurrentServerQueries? : number   -- default 3   
  ```

- To improve users experience when editing a dashboard, both timeouts and result limits are set to low values.
  Introduced the `IReportingOptions` configuration properties in the file `ic3report-config.js(on5)` :
  ```
  limits?: IReportingLimits {
  
     tidyTimeoutOnEditing?     : number   -- default 5
     tidyMaxRowCountOnEditing? : number   -- default 1000
  
  }
  ```

- Added HTML cell renderer transformation.

- Show in the editor when your query is outdated and needs to be updated.

- Improved custom drilldown menu.

- You can let users save the scrollbar of a chart into their browser.

- the `FORE_COLOR` property now determines the text color of a cell in a table or pivot table.

- Introduce `asMdxCsv` event accessor to escape quote characters.

- Moved the query loading indicator to the center of the widget.

- Removed `Disable Query Running` from the use menu icon settings.

- Table now clears its filter when doing clear selection.

- Table now shows the filter icon in a column when a filter is active in that column.

- Added option for auto-expand only when printing.

- The conditional color transformation does not remove existing colors.

- The conditional color transformation now compares null values when using `=` and a value of `null`.

- Conditional color transformation: added `!=`, _contains_, _not contains_, _starts with_, _ends with_ operators.

- Conditional color transformation: changed the order importance of the rules. Now, the first matching rule sets the
  color. Your dashboard is migrated automatically.

`MDX Query Builder`

- The graphical MDX query builder is supporting the newly
  introduced [DimensionProperties](../server/post_processing/DimensionProperties.md)
  post processor for adding member's properties as columns of the result.

`Filter panel`

- Search box now resets search when closed.

- Users can now remove individual items in the _is any of_ and _is none of_ filters.

- Changed the _is any of_ and _is none of_ layout to a scrollable list with showing the first 100 items in the
  selection.

- Added the level names to the global-event caption.

- You can now set an anchor date for the date shortcut selectors.

- The filter panel saves the selected shortcut instead of the dates of the shortcut.

- You can use shortcuts from the theme in the filter panel.

- Made the collapsed filter panel filter icon a button. (API: changes in
  `FilterPanelClasses.collapsedNumberOfFiltersIcon`)

- Removed the Compact variant from theme Statos.

`AI Chatbot`

- New chart option `Reset on Data Changed` : reset the conversion when the data of the widget the chatbot
  is talking to has changed.

`API`

- In the user menu, renamed `resetQuery` to `resetDrilldown`. Please search your theme if you are using `resetQuery`
  in `ic3ThemeOptions.userMenu.userMenuFilter`. Reports will be migrated automatically by icCube.

- Moved `ic3Theme.sparklineSettings` to `ic3Theme.sparklineSettings.line`.

- Changed `ic3Theme.sparklineSettings.line.cursor.lineWidth` to `ic3Theme.sparklineSettings.line.cursor.spotRadius`.

- Moved the column sparkline settings from the option editor into the theme at `ic3Theme.sparklineSettings.column`.

- Filter panel: added the `FilterPanelClasses.valueSelector` class name to the div containing the value selection.

- `IWidgetStableContext` : added `getDefiningReportName()`, `getDefiningReportPath()`, `getDefiningReportFolderName()`.

- Changed the default values of the `editorConf` of field types `tidyTableNumericStringColumnExpr`,
  `tidyTableNumericJSColumnExpr` and `tidyTableNumericColumnExpr` in the follow way: changed the default value of the
  `editorConf.useCurrentColumn`, `editorConf.userSelectsCurrentColumn` and `editorConf.useSelectedColumns` from true to
  false.

- Removed field type `tidyTableNumericColumnExpr`.

`API : icCube has updated the underlying component package. This is how you migrate your theme API :`

1. The theme overrides some types in _ThemeAugmentation.ts_. This functionality has changed. You can find the new
   _ThemeAugmentation.ts_
   here: https://github.com/ic3-software/ic3-demo-plugin-theme/blob/main/src/theme/ThemeAugmentation.ts.

* All `declare module "@mui/material/styles/*"` statements are now in a single `declare module "@mui/material/styles"`.
* `TypographyOptions` is renamed to `TypographyVariantsOptions`.
* `Typography` is renamed to `TypographyVariants`.

2. In your _webpack.common.js_ file, in the path `module.exports.plugins.ModuleFederationPlugin.shared`:

* Remove the line `"@emotion/styled": {singleton: true},`.
* Replace these lines:
  ```
  - "@mui/private-theming": {singleton: true},
  + "@mui/private-theming": {singleton: true, version: deps["@mui/material"]},
  
  - "@mui/material": {singleton: true, requiredVersion: deps["@mui/material"]},
  + "@mui/material": {singleton: true, requiredVersion: deps["@mui/material"], version: deps["@mui/material"]},
  ```

- Removed `PublicTidyColumn.hasColorProperty()`. Use `PublicTidyColumn.getColorColumn() != null` instead.

- Changed `PublicTidyColumn.getColorColumn()`. It now ignores the `MDX FORE_COLOR` property.

- Added `ThemeIc3WidgetBoxSpinner` to the theme components.

`Bug Fixes`

- Fix bug where sometimes the filter panel would show `schema not found` but the dashboard was loaded correctly.
  This bug occurred when using container scaling.

- In a widget with an SQL query, using a different schema than the one in the report did not work.

- Changed the default CSS class of typography `caption` to `body2` in these components:
    - theme API: The text in the filter panel selection popup: the count, and the reached limit text.
    - The type indicator in the query editor result.
    - Expression editor field title.

- An off-screen filter panel would not fire the event. This is now fixed.

- Makes the spark and bar and line charts pixel perfect in the KPI and table.

- Fix unnecessary re-render for an empty drilldown.

- Fix pivot table header spanning when using the same measure twice.

- Fix typing in search and replace transformation when replacing with numeric values.

- Fix numeric scale expression to not call `eval(...)` when it is just a number. Before you would get a CSP error, now
  it just returns the number.

- Fix column resizing for the tidy table in the MDX IDE.

- Fix empty pages and strange positioning in the printed PDF that would happen sometimes when you have invisible widgets
  in a grid layout.

- Fix drilldown and column properties. Sometimes, the column properties of the drilldown were not added (e.g., mdx-key,
  format string, color).

- Fix custom drilldown into another hierarchy of the same dimension. Sometimes the auto-exist would remove columns from
  the drilldown result causing the drilldown to fail and the widget to show waiting for event.

- Fix HTML-renderer transformation preview.

- Fix HTML-renderer removed an unnecessary div. This fixes cell-alignment.

- Fix the modify values transformation for pivot table left-header columns.

- Fix (auto)cancelling the MDX requests when the server is in `sessionLess` mode.

- Fix bug in the set format transformation when trying to set a format on a non-numeric column. Now this gives `null`
  values instead of `NaN` values.

- Fix the add row transformation did not format values in columns of mixed type.

- Fix the vertical scrollbar jumping while scrolling on large dashboards. This happened when you have widgets with
  auto-expand enabled.

- Fix the replace-null transformation did not add formatted values when the column has a format.

- Fix migrating a widget to another widget now also migrates the options.

<hr/>

### 8.6.2

<hr/>

`General`

- Clicking on the icCube logo now brings you back to the console.

- Ability to add a CSS class to the widget box.

`Gadgets`

- Reduces the size of the gadget image to 184 × 140.

`Filter Panel`

- Added an API for managing the filter panel views. You can define your custom API with the embedded API using:
  ```
  context.loadLibsAndInitialize({
    ...,  filterPanelViewStorageFactory: {} as any // <-- add here,
  });
  ```
  Check the `FilterPanelViewStorageFactory` interface for how to implement it.

- Added number of active filters indicator when the filter panel is closed.

`Date Picker`

- A datepicker with a query that returns `no rows` now shows `No Data` instead of an empty
  date picker.

`Pivot Table`

- Header Alignement : the behavior of the header alignment on 'Left Header Alignment' &  'Header Alignment'
  have changed to fix non-applied configuration (left or right). Please **review carefully** your dashboards
  with pivot tables.

- You now have to have the widget editor of the pivot table open to save and apply column width changes on the
  dashboard.

- Fix fluid column widths being too small by setting the minimum width of a column to 50px.

- Fix issue with resizing header columns after scrolling to the left.

- Fix cell on error rendering (the tooltip was possibly truncated).

`Table`

- You now have to have the widget editor of the table open to save and apply column width changes on the dashboard.

`AI Chatbot`

- Support for Azure OpenAI (see `icCube.xml` configuration of the server).

`API`

- Added `theme.ic3.icons.helpIconOutlined` to the theme API.

- Introduce the WidgetPublicStable context to avoid dependencies on query results that might trigger an unnecessary
  component refresh (React scenario). Former methods are marked as obsolete to facilitate migration.

- Added `IOnNewEventJsContext.getWidgets$()` to retrieve a list of widget boxes based on a JQuery selector.

- Added `HomeCard` and `HomeConsole` to MUI theme components.

`Bug Fixes`

- Fix: the Pivot Table header alignment on 'Left Header Alignment' &  'Header Alignment' chart options.

- Fix: the X-axis labels were jumping when updating the chart data.

- Fix: the dropdown filters when clearing the filter with your keyboard and having Empty Not Allowed would
  reset the filter. Now it will keep the empty state until you click away.

- Fix: in the schema browser, you can now drilldown into members when searching in the MDX tree in both the MDX
  Console and the MDX Query builder.

- Fix: an issue with the theme where the filter panel width CSS did not work.

- Fix: include tooltips in localization export.

- Fix: the table did not sort when loading from state when you had a hierarchical column.

- Fix: dragging a widget with an image did not work properly.

- Fix: zooming out a widget now keeps the scrollbar position of the dashboard.

- Fix: `@{ic3_reportName}` now shows the name of the embedded dashboard instead of the parent dashboard when used from
  an embedded dashboard.

- Fix bug in amcharts where hovering the scrollbar showed `%2` in Dutch locales.

- Fix: dragging the help dialog also selected text in Chrome.

- Fix: application editor maximizing a JS item raised an error.

- Fix: commented out filters in an MDX query (using e.g. `--FILTERBY @{year!∅}` or `// FILTERBY @{year!∅} `) are not
  shown anymore when hovering the filter icon in the widget menu.

- Fix: column selectors did not autocomplete `$` to `$$` in column names correctly.

- Fix: with the expressions, if you have a column name that starts with a `$` (e.g. `$col1`), then escaping with `$$`
  would not work. We found that you can use `$_ic3_dollars__col1$` to access columns where the name starts with a `$`
  can be accessed like that. This scenario is added to the documentation.

- Fix bug with expressions when the data in the table had a text value with `$&` in it. For example, for a column `col1`
  with cell value `test $&`, the expression `$col1$` returned:
    - before: `test $col1$`
    - now (fixed): `test $&`.

<hr/>

### 8.6.1

<hr/>

**IMPORTANT** : The Dashboards application 8.6.1 requires an icCube server 8.6.1.

`MDX Query Builder`

- Similarly to the graphical MDX query builder, highlight dimensions/hierarchies according to the actual
  measure groups used in the query has been added to the textual editors.

`Date Picker`

- Year and Month selections now display the chosen year or month, not the Day level anymore.

`Bug Fixes`

- Fix: in the application editor, the save button was always disabled.

- Fix: in dashboards with a filter panel, the column resize in the pivot was not working.

- Fix: editing a calculated member name was moving the cursor in the formula editor.

- Fix: editing Google Maps widget : `Set Zoom & Center` option was not working.

- Fix: typing date in date/range picker.

- Fix: the minimum date did not work due to time zone differences.

- Fix: the filter panel did not escape `"` in the property values.

<hr/>

### 8.6.0

<hr/>

**IMPORTANT** : The Dashboards application 8.6.0 requires an icCube server 8.6.0.

**IMPORTANT** : The MDX Query Builder widget has been temporarily removed. Please contact us if you were using it.

`Material UI`

- Upgrade to v6.

`MDX Query Builder`

- Improved MDX information in the schema browser and highlight dimensions/hierarchies according to the actual
  measure groups used in the query.

`Table`

- Added option `Show Hierarchy` to render the first column as a hierarchy.

`Pivot Table`

- Several performance improvements to support the rendering of larger pivot tables.

`ic3-demo-plugin-theme`

- Added an example print layout with a header and a footer.

`Bug Fixes`

- Fixed the widget selection box in the editor when your theme has a different value for `themeSpacing`.

- Fix select all search results in filter panel hierarchical filter for dimensions with fact aggregation set to
  `member only`.

- Increased the zIndex from `1` to `1300` on the range picker dropdown menu. In some embedded scenarios, it appeared
  behind the dashboard.

- Date picker: single date picker with two levels in the query produced an MDX error instead of the correct event.

- Date picker: fixed a regression with timezone when printing (possibly shifting the selected day).

- Date range picker: having the start or end of the range be a date that does not exist in the level produced a wrong
  filter: it would include all the dates below/above the non-existing date.

- Pivot table: add some right padding when there is a vertical scrollbar to prevent the scrollbar overlapping cell-data.

- Filter panel: fix sometimes a node in a hierarchical filter did not show that children were selected.

- Filter panel: pressing enter now opens the item picker if the text field is focussed.

- Fixed: charts and tables initialized the selection when it was not enabled.

- Fixed: no more `eval` calls in numeric expressions when it is not needed.

- Fixed pivot table drilldown with multi-hierarchy axis.

- Chart levels added an unnecessary grid-line on the y-axis.

- Chart levels added unnecessary labels when using CSV sources.

- Fixed an issue when printing a dropdown widget that had a column set in the `item > items` option.

- Fixed layout height issue with embedded reports.

<hr/>

### 8.5.1

<hr/>

`Bug Fixes`

- Fix printing being cancelled before completion.

- Fix drilldown with user defined MDX expression.

<hr/>

### 8.5.0

<hr/>

`Widgets`

- New widget : [switch](../dashboards/widgets/ic3/filter/FilterSwitch.md).

- Charts and tables now also have initial selection options.

- Removed selection from the Gauge chart. It was not used.

- Changed the chart styling in the default theme Statos: removed the border for the column/bar charts. Made the border
  smaller (was: 2px, now: 1px) for the other charts.

- Added search information to large dropdown item selection.

- Fixed the tree filter not having a scrollbar when using autocomplete.

- Fixed the large autocomplete filter search. Before it was searching on the non-localized name. Now it searches the
  localized names of the members.

- Fixed the center text localization of the date range picker in Dutch. Now it is `t/m`.

- Added option `maximum selection` to the dropdown filters. Use this option to control the maximum number of items a
  user can select.

`API`

- `IReporting.openReport` is keeping the changes possibly made to the report definition and theme for later
  prints. The functions `IOpenReportOptions.onDefinition` and `IReportDefinition.setChangeThemeCallback`
  are possibly introducing some **breaking changes**. Please review their Javascript documentation for
  more details.

- Removed `PublicTidyColumn.getInitialSelectionRowIndices`.

- Added `IThemeManager.registerThemeProcessor`. Use this method in combination with the `setThemeProcessorCall`
  method of `IReportDefinition` from the embedded API. With theme processors, you can use Javascript code to change
  the theme.

- Added `IOnNewEventJsContext.localize()` method for localization purpose.

`Filter panel`

- Added tree selection for hierarchies with fact aggregation `Member Only`.

- Added item validation. Now, when restoring a filter panel from a view or option, it validates all the items and sets
  them to `{}` if they are not found.

- Items from default filters are now localized. You can now set a default filter and users will find the default items
  translated to their locale.

`Transformations`

- `Add an Aggregation Column`:
    - renamed to `Add Total Column`.
    - it now considers the hierarchical structure of the table.
    - the column is now always marked as a total column.

- `Add (sub)totals`
    - now considers the hierarchical structure of the table.

`Bug Fixes`

- Printing is taking into account the changes possibly made to the report definition and theme when opening a report
  using the `IReporting.openReport` function (embedded API).

- Fixed `Add Event to Queries` : was broken when used from a `Gadget` filter; the dashboards queries were not updated
  accordingly.

- Fixed an issue with re-ordering columns in the table and having a filter panel active on the same page.

- Fixed issue in the charts where the bullet labels went missing when switching to and from a datetime axis.

- Fixed Dutch localization for the table show/hide column menu.

- Fixed Table: save to state broken when switching fast after changing the table.

- Fixed Table: the row click event was not firing with drilldown active.

- Fixed Table: pinned column did not get selected styling.

- Fixed Table: printing with a drilled down table gave an error.

- Fixed Table: a selected row now unselects when it is filtered out of the table.

- Shift values transformation: now also the properties of a column are shifted.

- Search and replace value transformation gave the wrong column type when replacing values with `null`.

- Setting the query for a new datepicker widget did not pre-fill the event name. Now it does.

- Add totals transformation now aggregates values w.r.t. the hierarchical structure of the columns in the table.

- Fix pivot table total row was not bold when collapsing a node in the table.

- Fixed CSS issue with dropdown filter `Grouped Text` variant. The input had no space if the selected option(s) were too
  wide.

- Fixed CSS issue in the editor. Dropdown filters with multiple options could only be selected by the widget header.

- Changed search behavior of dropdown filters. Now your search remains active, so you can select multiple items in your
  search. Click away to clear the search.

- Fixed behavior of large dropdown to have it function like the small dropdown.

- Fixed set to initial selection option in user menu of the small and large dropdown.

- Fix pivot table with total row showing the `Total` text multiple times on the total row instead of once. Now it shows
  only once.

- Fixed styling was not applied to the loading screen of the single filter panel widget.

- Fixed: when not using the filter panel as a global event, the other widgets now wait for the initial filter to load.

- Fixed set type transformation not changing null-column types.

<hr/>

### 8.4.14

<hr/>

`Widget Editor`

- Horizontal scrollbar enabled when the widget editor (i.e., right drawer) is opened.

`Filter Panel`

- Added drag-and-drop to the filter panel items. Removed animations.

- Added option for max number of views a user can add.

`Table`

- Added option for storing the state of the table in the users' browser. This state loads automatically
  when loading the dashboard.

- Enhanced pivot like drilldowns to look like the pivot table.

`AI Chatbot`

- Use data after transformations.

`Transformations`

- Added `Group Data Points` transformation ([www](./tidyTable/transformations/TransformationMergeCloseDataPoints.md)).

- Added `Operator Scheme` to the `Group By` transformation:
    - `All` : use all operators for all columns (DEFAULT).
    - `Per Column` : Use the ith operator for the ith column.

- Added `List to String` transformation ([www](./tidyTable/transformations/TransformationListToString.md)).

`Bug Fixes`

- Fix: AI Chatbot printing w/ state (was missing `RENDERED` status).

- Fix: filter panel non-empty not applied on the list of items in the filter. It only worked before
  when you already had another filter active in the filter panel.

- Fix: `clear-selection-all-widgets` notification would clear the selection for widgets where the selection
  was not active.

- Fix: table column resizing sync to the editor.

- Fix: the CSS class of a layout in the API was not applied. Now it is applied to the `Layout-root` div.

- Fix: having two `Add Total` transformations on the same column added unnecessary rows.

- Fix: selection event when selecting a total row in the table.

<hr/>

### 8.4.13

<hr/>

`AI Chatbot`

- Introduced a [chatbot](./widgets/ic3/misc/AIWidgetChatBot.md) widget that allows for asking a LLM any question about
  the data of a widget. Note this feature is **still in beta mode**. Please review the `aiConfiguration` section in the
  server configuration file `icCube.xml` for configuring the LLM being used (e.g., Ollama, Gemini, OpenAI).

`General`

- Introduced the drilldown path into the widget header.

`Transformations`

- Added `Percentage of Row` transformation.

- The `Sort Transformation` has an option to sort w.r.t. hierarchies.

`Data Accessors`

- Use `$_tableExclude$` to access the table and exclude some columns and rows.

- New `_tableRelative` function to retrieve table cells using coordinates relative to the current row and column.

`Events`

- Introduced [global events](../dashboards/interactions/GlobalEvents.md) giving access to dashboard global
  information (  e.g., user, schema, etc...).

`KPI Card`

- Introduce target delta zero to handle numerical rounding issues when the target value is close to zero.

`Filter Panel`

- Added clear value button in the field if you have a value.

- In the allowed/not-allowed filters options, you can now use shortcuts:
    - `[...].levels` to use only the levels in the dimension/hierarchy/level,
    - `[...].properties` to use only the properties in the dimension/hierarchy/level,
    - `[...].all` to use all from the dimension/hierarchy/level,
    - `[...].hierarchies` to use only the hierarchies from the dimension/hierarchy/level.

- Added _autosave filters_ option to filter panels in an application.

- Added filter panel views: allow users to save and load filters (filters are stored in the users' browser storage).

`API`

- Added `FilterPanelClasses.inputFieldSetValueButton` in the theme to customize the set value button more easily.

- Changed the class of the filter panel help icon button from `FilterPanelClasses.titleDiv`
  to `FilterPanelClasses.titleDivButtons`.

- Changed the widget header div layout. Added div: `ic3WidgetBox-headerLeft` and div `ic3WidgetBox-headerRight`. Change
  your theme accordingly.

`Bug Fixes`

- Fix: the definition of gadgets were possibly not migrate to latest dashboard definition.

- Fix: pressing backspace in a text-input field in a widget when editing removed the widget.

- Fix: hover information in the filter panel for hierarchy filters.

- Fix: using the filter panel to filter a widget with an empty query returned an error. Now, with the fix, it keeps
  the 'waiting for event' state.

- Fix: line chart option *Hide Line Bullets*. Disabling and then enabling the line by clicking in the legend showed the
  bullets again when they should remain hidden.

- Fix: y-axis maximum/minimum not working for the second y-axis in the combo chart.

<hr/>

### 8.4.12

<hr/>

`General`

- Filters clear event when switched from data to no data (made consistent for dropdown, button, checkbox, slider
  and tree filters).

`Table & Pivot table`

- Added `cellTooltips` option to always show tooltips when hovering a cell.

- Changed CSS to show `…` when a cell value is too long for the cell.

- Cleaned the styling of the pivot table by removing some padding.

`API`

- `ic3Components` deprecated : use `Components` instead (to override the date picker and the data grid classes) :

```
    - import {ic3Components} from "./PublicTheme";
    + import { Components } from "@mui/material/styles"; 
```

- Added theme example on how to extend the MUI X Pro components (data grid and date picker).

- Added variant to chart options for `FilterDatePicker`.

`Bug Fixes`

- Fix: pivot table corner text also responds to the 'Wrap Top Header' option.

- Fix: single filter panel event captions are now nicely formatted.

- Fix: add single selection to Table with checkboxes.

- Fix: The table got an error when sorting a column and then clicking in a chart.

<hr/>

### 8.4.11

<hr/>

`Gantt Chart`

- Added option __: If enabled, show groups in the same lane instead of in their separate lanes.

`API`

- icCube now uses MUI 7. If you have a plugin with a theme for the table, then read this document for how to migrate:
  https://mui.com/x/migration/migration-data-grid-v6/.

`Bug Fixes`

- Fix labels positioning in donut chart with a lot of hidden labels.

- Fix label auto-wrapping in column chart with different font-sizes.

- Fix set size in filter panel when using properties.

- Fix copy/paste widget from another tab.

- Fix 'SEND MDX TO IDE' sending compressed value.

- Fix printing w/ large state throwing an error related to `maxFormContentSize` on the server.

- Fix KPI box widget not having variant `plain`. Changed the default variant to `undefined` and
  changed the default CSS to take the typography from the theme.

- Fix date-picker timezone.

- Fix chart date axis by removing time zone.

- Fix Gantt chart: some date values got grouped into months. Now it displays correctly the date value.

<hr/>

### 8.4.10

<hr/>

`General`

- Introduced the configuration properties in the file `ic3report-config.js(on5)` :

```
    IReportingOptions.contentLocalizationsFallbackLocale
    IReportingOptions.localStorageContentCompress
    IReportingOptions.localStorageContentEvictionDays
```

- Removed the configuration `IReportingOptions.enableWidgetAutoSave`. Please contact us if you were using this feature.

- Introduced the possibility to autosave the [state](./interactions/DashboardState.md) of the filters of a dashboard in
  the browser local storage. So when, you open the dashboards in the future, it will re-use the previously saved state
  and re-initialize all the filters accordingly. This feature can be activated in a theme (default value) and overridden
  within each report properties.

`Layout`

- Introduced Fixed position (aka. sticky) for widgets in layout with unlimited height. Not supported in Grid layout.

`Table`

- Added option for check box row-selection. Option is in `Columns > Checkbox Selection`.

- Renderers can now stack. If you have a cell renderer for row 1 and another for row 2, then both renderers will show.

`Filter Panel`

- Remove duplicated unknown members in a hierarchy filter.

`Editor`

- Added drag and drop to change order in field editors with multiple values.

`API`

- Layout : added `IPageHeaderFooterDefinition.printOnly` option.

- Context : added `IPublicContext.isAppXyz()` and `IOnNewEventJsContext.isAppXyz()` methods to identify the type
  of the current application (e.g., editor, viewer, etc...).

- Transformation : a transformation can run with a warning (e.g., the column in `Set Caption` is not found).

- Removed `PublicTidyColumnCellDecorationRenderedOptions` from the transformation cell renderer API as it was not used.

- Added `args` to `IWidgetPublicContext.translateContent(...)`.

`Bug Fixes`

- Pivot-table : fix collapse error when auto-expanded and initial query contains all the children.

- Printing / Layout conversion : fix missing header/footer.

- Date Picker : fix selecting a shortcut not firing the event.

<hr/>

### 8.4.9

<hr/>

`General`

- Added `defaultDatetime` formatter to theme. Datetime values use the `defaultDatetime` formatter
  and date values use the `defaultDate` formatter.

- Added `Logout` action to the Dashboards Application menu.

`Data Accessors`

- Add Javascript utility functions `util.getColumnValue` and `util.getCurrentColumnValue` to get column values.

`Tree Map Chart`

- Improve readability of the labels.

`Filter Panel`

- Improve date/time filters. Improve range selector with shortcuts. Removed _Is Any Of_ and _Is None Of_ selectors for
  date/times that are not from a time dimension.

- Fix bug where the min/max of a date picker was not set for date(time) properties.

`Date Range Picker`

- Improve range selector with shortcuts.

- Localize the ` to ` text.

`API`

- Added `getReportName()` and `getReportFolderName()` to `IWidgetPublicContext`.

`Bug Fixes`

- Fix resizing widget in group when the cursor is outside the group (was throwing an exception) .

- Fix regression in pivot-table vertical scrolling using the mouse wheel.

- Fix page height for responsive (grid) layout (was missing half of the row-spacing).

- Fix center text of gauge chart not updating when applying a filter.

- Fix widget not selectable after dashboards refresh in the editor.

- Fix KPI Box widget not being able to edit icon settings.

- Fix Invisible custom widget (not being a filter) sending events.

- Fix table multi-header alignment.

<hr/>

### 8.4.8

<hr/>

`General`

- Renamed `Dropdown Filter (lazy)` into `Large Dropdown` and `Dropdown Filter` into `Simple Dropdown`.

- Add Drilldown event to widgets with query drilldown. The event is an MDX tuple with the drilldown path.

`Data Accessors`

- Use `$_tableExclude$` to access the table and exclude some columns and rows.

- Allow negative index to start from the end. For example, `Amount(-1)` returns the value of the last row
  of the column `Amount`.

`Filter Panel`

- Clear filter button now shows tooltip when disabled.

- Changed placeholder text to use `Set value` instead of `Search Contains`.

- Hide operator selector when just one operator.

- Added select search results button.

- Improved model selector (Single Filter Panel widget).

`API`

- `IAppNotificationCallback.onError` : returns true if the error has been handled and the default icCube
  error handler won't be called.

- Added `options` type to the Hook API.

- Added option to change the widget icon defaults for each widget from the theme. See `widgetDefaults.widgetIcons`.

- In the filter panel classes, added `FilterPanelClasses.filterItemClearButtonContainer` for the container around
  the filter clear button.

`Bug Fixes`

- Fix pending requests on Refresh Dashboard on Data Update for embedded and report application usages.

- Fix filter panel unexpected uncaught promise rejection.

- Fix filter panel unexpected auto-cancel error.

- Fix filter panel refreshed on schema refreshed (was ignored).

- Fix filter panel rendering long level names outside the filter.

- Fix theme `widgetIcons.disableWidgetIconsEdition` not using the widget icon defaults.

- Fix theme defaults in widget box settings were not shown in the editor.

- Fix very quick report switch from host application (possibly giving an empty report layout).

- Fix switch layouts from different themes (e.g., loosing widget pages).

<hr/>

### 8.4.7

<hr/>

`Enhancements`

- Added event name localization. The translation is shown when a user hovers the filter icon in the widget header.

- Improved tidy table format on the wire for a faster network transfer and a faster parsing in the browser.

`Filter Panel`

- Always allow users to select from the default filters to prevent errors.

- If no cube is specified, filters for all hierarchies are considered.

`Dropdown Filter`

- Make placeholder text translatable.

`Bug Fixes`

- Single filter panel : always started with `is any of` filter. Now it starts with the first allowed operator.

- Pivot Table : fix wrong scrollbars in touch screen.

- Printing / Layout conversion : widgets possibly badly placed when more than one page is generated.

- Printing : wrong widgets sizes with multi. pages dashboards and widget-content-scale applied.

<hr/>

### 8.4.6

<hr/>

`Editor`

- Introduced unsaved dashboard definition in browser local storage or local file system on save error
  (e.g., session timeout) for later recovery.

`Print`

- New documentation [page](printing/Printing.md) that is acting as an entry point for all information
  related to printing a dashboard.

- Both desktop (aka. single page and unlimited height layout) and [responsive](./layouts/GridLayout.md) layouts
  can be printed using the new automatic layout converter that is trying to fit as good as possible the widgets
  according to the printer paper size. The option `Fit To Page` has been removed in favor of this converter.
  Please contact us if you were using this feature.

- The Statos `A4`, `Letter`, etc... layouts are using the new `widgetContentPrintScale` configuration (`0.64`)
  that is scaling down the content of the widget when printing. **You can adjust this value in your own theme**.
  Please review the [migration](../server/user_guide/migrating_iccube/8_4_5_to_8_4_6.md) document.

- Print Button widget : introduced `paper size` and `paper orientation` options (was `A4:Portrait` always).
  Those options are defaulted to `A4:Portrait` and the margins are derived from the paper definition as defined
  in the server (`icCube.xml`). As with any other widget option, the default values can be changed via the theme :
  `widgetDefaults: { options: { ic3: { PrintButton: { paperSizeName: "Letter" } } } }`.

`Transformations`

- Added conditional color transformation that does not use JavaScript (CSP compliant). Renamed the existing
  transformation to Color Conditional JS.

`Filter Panel`

- Added option to control the operators the user can choose from.

`Single Filter Panel`

- Added default filter.

`Gantt Chart`

- New chart.

`Reporting API`

- Theme : new `widgetContentPrintScale` configuration that is scaling down the content of the widget when printing.

- Layout : new `applyWidgetContentPrintScaleForRendering` configuration to apply the `widgetContentPrintScale` for
  the rendering of the widget in the editor as well.

- New options for the [responsive](./layouts/GridLayout.md) layouts : `print` and `printLandscape` defining both the
  multiplier and spacings used when printing the dashboards. Please, refer to the `ic3-demo-plugin-theme` Github's
  project for a complete example.

- Added the optional argument `context` to `getFormattedValueOrValue` in tidy column. When added, it uses the default
  formatters from the theme.

- Removed `emptyCell` field from the theme.

`Bug Fixes`

- Print : fix possibly missing table rows in generated PDF.

- Print : remove extra blank page in generated PDF.

- Table : sometimes not showing a correctly formatted date/time value.

- Repetition Widget : fix `Zoom In/Out` action.

- Editor : several fixes for working with zoom active.

- Editor: add event to queries was not working for KPI cards.

- Editor: measure can now be used as a `where` filter statement in the query builder.

<hr/>

### 8.4.5

<hr/>

`Data Accessors`

- Add `columIndex`, `groupColumnIndex`, `rowCount` and `columnCount` modifiers.

- Add Javascript utility functions `util.colorInterpolate` and `util.colorLightness` to modify colors.

`Cell Renderers`

- All cell renderers work as well in the Pivot Table.

<hr/>

### 8.4.4

<hr/>

`Layouts`

- New [Responsive](./layouts/GridLayout.md) layout : allows for creating dashboards that automatically
  adjust to fit different screen sizes (e.g., desktop, laptop, smartphones).

`Theme`

- Improve consistency in selection colors, use blue instead of icCube purple.

- Lighten on-hover color effect.

`Charts`

- **IMPORTANT** : the format string `#` behaves like `#.`, removing all decimals.

- Add `groupValue` and `percentGroup` data accessors for charts defining a group role (i.e. Stacked Columns)

`Filter Panel`

- Added _not allowed filters_ option.

`Autocomplete`

- Popper does not close on selection if multiple selection is active.

- Multiple selection adds an overflow if needed in the input box.

`Pivot Table`

- Add sortable option for the left header.

`Reporting API`

- A theme can define number/date formatters per locale.

- Introduced `IWidgetLayoutDefinition.layoutGroup` and `IWidgetLayoutDefinition.layoutName`.

- Allow firing events from a custom transformation.

- Remove `ITidyBaseColumn.getMdxCoordinates(rowIdx: number)` method.

- Added `IPublicCommonWidgetTemplateDefinition.withOptionAutoExpandHeightNotDependingOnWidth` flag.

`Embedded API`

- `DashboardsLoaderFrame()` does nothing if the `iFrame` is present using ( `frameId`, `url` ) as key.

`Bug Fixes`

- Transformation : modify values was not working when converting from date to character.

<hr/>

### 8.4.3

<hr/>

`General`

- **Requires an icCube server v8.4.3** to get the new features of the date picker.

- **[Breaking Change]** Date picker: query options added, including intersecting two or more date ranges.
  The _Chart_ > _Date Unique Name_ default value has been changed. Requires a server v8.4.3.

`Charts`

- Sankey diagram: queries with 2 columns used to have from-to logic enabled by default. Now, the default is to treat
  nodes in different columns as different nodes in the sankey. You can change this logic with
  the `Merge Nodes` option in the Sankey Diagram.

- Filter Panel: fixed searching items not working for translated MDX members.

- Value labels in bubble/line/area/stacked area chart have position _end_ as default (was _middle_).

- Bubble chart now has default value label equal to the bubble size (was empty).

- Combo chart has value labels.

- Combo chart added the option to change the series type from line to column.

`Reporting API`

- The combo chart options has changed (review the API source code for the new names).

<hr/>

### 8.4.2

<hr/>

`General`

- **Requires an icCube server v8.4.2** to properly support the new help/documentation.

`Charts`

- The transformation 'Set Header Color' sets the header color. The chart will use the header color if it is defined.
  Before it used another color.

- Filter Panel: now has _reset filter_ button instead of _remove filters_ button. CSS class changed, check the API for
  the new name.

`Plugins`

- Custom widget documentation in Docs (e.g., `ic3-reporting/app-local/doc`) has been moved inside an extra folder.
  The root folder should now be `dashboards`. For example:

```
      /doc
        /fr
          /dashboards
            /tidyTable
              /transformations
                /MyPluginJS
            /widgets
              /MyPluginJS
```

`Bug Fixes`

- Filter Panel : allowed filters was not filtering hierarchy filters.

- Filter Panel : fix CSS styling for large option names.

- Tree Filter : was closing when selecting an item in dropdown mode.

- Tree Filter : fire compacted now only shows the compacted selection.

- Stacked Charts : hide the non-applicable trend line type option.

- Chart with legend showed error when switching to a date/time axis.

<hr/>

### 8.4.1

<hr/>

`Charts`

- Donut chart highlights the selection by making the unselected labels more transparent

- Use `theme.palette.ic3.selectedChart` for dynamic selected colors a chart instead of a single color. See the example
  in the API.

`Embedded API`

- Added method to change the default dashboard path when opening an application.

`Bug Fixes`

- Bar charts label spacing for numbers.

- Donut chart `totalSelectedOrTotal` not working after dashboard refreshes.

- Filter Panel: valid filters that are in the default/allowed configuration should always be visible in the _add filter_
  menu.

<hr/>

### 8.4.0

<hr/>

`General`

- **Requires an icCube server v8.4.0.**

- Upgrade to React18

- **[Breaking Change]** Tables and Pivot Tables do not apply by default color decoration on headers, you need to set
  applyHeaderColorDecoration.

- **[Breaking Change]** Theme TreeFilter, VirtualizedTreeItem is not longer a slot, use FilterTree as the main
  component and FilterTreeClasses.itemRoot class in the root directly.

- New Safe Mode when editing a report. When in 'no query mode' the report will not fire queries to the server.
  Available in the top-right user menu.

`Widgets`

- The widget/gadget editor-panel is now resizable.

- The widget help dialog now uses the widget title. Also, it opens near the user's mouse.

- The widget header shows a filter icon if any filters are active for that widget. Hovering the icon reveals
  which filters are active.

- Add Widget Actions (user menu actions can be triggered with events)

- Cell renderer transformations are now hidden for non-table widgets.

- Filter widgets get a publish event name generated when it is empty.

- Filter panel improvements:
    - Add filter menu:
        - Do not show the tree if only one level in the hierarchy.
        - Group the filters by dimension instead of by the hierarchy. Hovering the option shows the hierarchy of the
          filter.
    - Numeric filters now also have _is any of_ and _is none of_ operators.
    - Filters now use the key-type of the level. Date/time keys use the datepicker and double/float keys use
      the numeric filter.

- Tidy table query result used to show the value, now it shows the formatted value. Also, it now sorts on the
  `datetime` property if it exists.

- In the charts-axis, the initial zoom now includes the end index so that you can zoom to the last value of the axis.
  Also, negative values count from the end of the axis. E.g., `-10,-1` zooms to the last 10 items.

- Amcharts value ranges: a line for each measure in the data.

- Trendlines in charts now use the color of the column/line that the trendline is based on. To override, you can set
  the color in the options or change the header color of the column using a transformation.

- Histogram add algorithm for automatic buckets with rounded intervals.

- Donut Chart: added `selectedTotalOrTotal` in center text to show the total of the selected slices.

- Divergent Bar Chart: you can now change the left- and right label.

- Table Chart: remove the `footerSelectedRowCount` option.

- Transformation: added search and replace.

`Theme`

- Added `smallNumberPrefixes` and `bigNumberPrefixes` to the theme formatter options (API/Plugin) to override
  the default prefixes. E.g., 1,000 -> 1.0k | 1,000,000 -> 1.0Mio.

- Added an example (in `ic3-demo-plugin-theme`)to disable the widget box shadows when printing.

- You can add chart variants, see the GitHub theme demo for an example.

`API`

- The NPM package `@ic3/reporting-api-embedded` has been introduced. It contains the code for embedding icCube into
  an existing Web application. The package `@ic3/reporting-api` does not contain anymore this embedding code.

- `context.createTableMarkdownExpr` argument order changed and `currentColumn` and `selectedColumns` added.

`Bug Fixes`

- Fix date picker giving the wrong query result, causing errors if the date column is mapped in the options.

- Fix the height of the filter panel when embedding using a div.

- Fix the horizontal scrollbar not showing in the query expression editor.

<hr/>

### 8.3.0

<hr/>

`Gadgets`

- A gadget is a widget with its query (and other options) that can be added to a dashboard.

`Filters`

- Filter MDX Query: ensure to have `CELL PROPERTIES CELL_ORDINAL` at the end of the query.

- Added the single panel filter: it is a single filter item from the filter panel.

`Widgets`

- Table Widget: the default value for the cell and header alignment is now `auto`. It means that numeric
  columns align to the right, and other columns to the left.

- Table & Pivot Table Widgets: the CSS class `ic3-total-cell` is added to the cell if it is a total.

- Combo Chart Widget: migrated enable/disable _Right Y-Axis_ option to the options _Draw On Axis_ in the line and column
  option groups. If you have disabled the right y-axis, then the application migrates the report to sets _Columns
  Series > Draw On Axis_ to `left` for you automatically.

- Embedded Dashboard Widget: can use relative paths. For example, `../test-report` opens the report
  called _test-report_ one folder up. Another example, the path `FY2022 overview` opens the report called _FY2022
  overview_ in the same folder as the report with the embedded widget.

- Print Button Widget: a new widget that is printing the current dashboard (simpler to create than the generic
  application notifications).

- Field meta `columnsChooser` now has the mapping from previous options as an argument in `fallback`.

- Changed the function call signature of `LazyTreeViewProps.setSelected` to have arguments `MouseEvent` and `treeData`.

`Theme`

- Removed `loadFonts`. Move `WebFont.load` to the start of the theme-definitions file.
  Have a look at the demo-theme-plugin.

- Moved `palette.mdx` to `palette.ic3.mdx`.

- New option `theme.ic3.treeFilter.itemHeight`, to set the height of the tree-items.

`API`

- Embedding icCube in a DIV: improved configuration for Cross Domain scenario.

- Added `getColumnsByAlias` to the tidy table.

- Improved `IReporting.fireAppNotification` for managing print status.

- New methods for retrieving existing dashboards and dashboards applications.

- Migrated treemap `labelExpression` to `labelExpressionHTML` and `labelExpressionText` depending on `labelType`.
  Migration is done automatically for reports.

`Bug Fixes`

- Fixed bug where `getOptionalColumnsByAlias` and `getColumnsByAlias` did not return the column selected by the user.

<hr/>

### 8.2.2

<hr/>

`Theme`

- **[Breaking Change]**: All CSS classes are starting with ic3.

`Console`

- Introduced Open Dashboards | Applications cards for read-only users.

`Plugins`

- **[Breaking Change]**: Plugin definition: introduced a logger parameter in `registerXyz` methods.

`Repetition Widget`

- Improved rendering speed.

`TreeFilter`

- Improved rendering speed by virtualizing the component.
- **[Breaking Change] Tree-items now use different classnames for styling.

`Table & Pivot Table`

- You can add cell tooltips using the Add Tooltip Property transformation.

`Expressions`

- Use `@` to access column properties. Use `mdxName`, `mdxCaption`, `mdxUniqueName` or `mdxKey` to get MDX related
  info of the cell-value.
- Use `_table`, `_currentRow`, `_currentColumn`, `_selectedColumns`, `_rowOfSelectedColumns` or `_currentCell` to
  access values other than columns.

`Combo Chart`

- You can now use only the left axis. The right axis can be disabled in the chart options.

<hr/>

### 8.2.1

<hr/>

`KPI Box`

- **[Breaking Change]** Removed option: `Background Color` => use the theme / box-variant to change
  the background color.
- **[Breaking Change]** Removed option: `Columns` => use role-accessors in the markdown expressions
  to get columns from the query.

`Dropdown (aka. Autocomplete) Filter`

- **[Breaking Change]** The `Lazy Load` or `Lazy Search` option has been removed. Instead, a new `Dropdown (lazy)`
  widget has been introduced. Manual update is required.

`Widgets`

- Introduced data row limit to prevent breaking their rendering. Those limits can be overridden
  via the reporting configuration (see Docs app-local `ic3report-config.js` file).

- Table: add column ordering option.

- Introduced widget state auto-save in the browser local storage.
  Support for table state (column ordering, sorting, etc...).

- Event accessor: introduced the `asKey` getter to retrieve the MDX member's key when available.

`ic3-demo-plugin-theme`

- Added an example for a custom `editor` (vs `dashboard`) theme: e.g., replace the icCube logo,
  change the colors, etc...

<hr/>

### 8.2.0

<hr/>

- Ability to disable editor features from user's role.

`ic3-demo-plugin-js`

- Javascript widgets: add amCharts 4 example.

<hr/>

### 8.1.1

<hr/>

`ic3-demo-plugin-js`

- Javascript widgets: introduced renderOnResizeJS().

<hr/>

### 8.1.0

<hr/>

- Table/Pivot-Table query change (#measures introduction): might require manual widget query migration.

- New dashboard global Javascript onNewEvent() handler.

- Refactor keyboard management (i.e. Ctr+C).

`ic3-reporting-api`

- Adding support for embedding icCube via a DIV.

- ITidyMath instance is available from TidyTable.

`ic3-demo-plugin-js`

- Add example of a customer table cell renderer (TransfRendererCustom).

`ic3-demo-plugin-react`

- Add example of a customer table cell renderer (TransfRendererCustom).

- Add example of a Google Map widget with markers.

- Add example of an Open Layer widget.

`ic3-demo-plugin-theme`

- Fix unexpected overwrite of the Statos theme.

`ic3-demo-embedded-react`

- Rename from ic3-demo-embedded-react.

- Add examples for DIV integration.

_
