/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.mongodb.datatable.mapreduce;

import com.mongodb.Cursor;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbTableRowReaderOld;

public class OlapBuilderMongoDbMapReduceTableRowReader extends OlapBuilderMongoDbTableRowReaderOld<OlapBuilderMongoDbMapReduceDataTable>
{
    protected OlapBuilderMongoDbMapReduceTableRowReader(OlapBuilderContext context,
                                                        OlapBuilderConnectionPool connectionPool,
                                                        int maxRowCount,
                                                        OlapBuilderMongoDbMapReduceDataTable table,
                                                        String fullNameForEndUser)
    {
        super(context, connectionPool, maxRowCount, table, fullNameForEndUser);
    }

    @Override
    protected Cursor initCursor()
    {
        return OlapBuilderMongoDbMapReduceHelper.mapReduce(context, connection, table);
    }

}
