/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.mongodb.datatable.find;

import com.iccube.bson.ic3BsonRow;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTablePartitionKey;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbTableRowReader;
import org.bson.Document;
import org.bson.conversions.Bson;

class OlapBuilderMongoDbFindTableRowReader extends OlapBuilderMongoDbTableRowReader<OlapBuilderMongoDbFindDataTable>
{
    OlapBuilderMongoDbFindTableRowReader(OlapBuilderContext context,
                                         OlapBuilderConnectionPool connectionPool,
                                         int maxRowCount,
                                         OlapBuilderMongoDbFindDataTable table,
                                         String fullNameForEndUser,
                                         IOlapBuilderTablePartitionKey partitionKey)
    {
        super(context, connectionPool, maxRowCount, table, fullNameForEndUser);
        this.partitionKey = (OlapBuilderAbstractTablePartitionKey) partitionKey;
    }

    static Document first(OlapBuilderMongoDbConnection connection, OlapBuilderMongoDbFindDataTable table)
    {
        final MongoDatabase bd = connection.getMongoDataBase();
        final MongoCollection<Document> collection = bd.getCollection(table.getCollection());

        // Query
        FindIterable<Document> findQuery = collection.find(toBson("query", table.getQuery()));
        // projection
        findQuery = findQuery.projection(toBson("projection", table.getProjection()));
        return findQuery.first();
    }

    @Override
    public void doInit()
    {
        initConnection();

        final MongoCollection<Document> collection = getCollection(table.getCollection());

        // Query
        final Bson filter = getFilterQuery();
        FindIterable<ic3BsonRow> findQuery = collection.find(filter, ic3BsonRow.class);
        // projection
        findQuery = findQuery.projection(toBson("projection", table.getProjection()));
        // limit
        if (table.getLimit() != null)
        {
            findQuery = findQuery.limit(table.getLimit());
        }
        // batch size
        if (table.getBatchSize() != null)
        {
            findQuery = findQuery.batchSize(table.getBatchSize());
        }
        result = findQuery.iterator();
    }

    private Bson getFilterQuery()
    {
        final Comparable incrLoadMarker = context != null ? context.getIncrementalLoadMarker(table) : null;

        final Bson filter;
        if (incrLoadMarker == null && partitionKey == null)
        {
            filter = toBson("query", table.getQuery());
        }
        else
        {
            if (!table.hasQueryIncrLoadPart())
            {
                filter = getColumnBasedFilter(incrLoadMarker);
            }
            else
            {
                filter = toBson("query (incr.)", table.getQueryIncrementalLoadPart(incrLoadMarker, partitionKeyForReplacement()));
            }
        }
        return filter;
    }


}
