/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.mongodb.datatable.find;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbDataTableValidator;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbDataTableWithPrototypeValidator;

public class OlapBuilderMongoDbFindDataTableValidator extends OlapBuilderMongoDbDataTableValidator
{
    public OlapBuilderMongoDbFindDataTableValidator()
    {
    }

    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderDataSource<OlapBuilderMongoDbConnection> dataSource, IOlapBuilderDataTableDef<OlapBuilderMongoDbConnection> dataTable)
    {
        final OlapBuilderMongoDbFindDataTable table = (OlapBuilderMongoDbFindDataTable) dataTable;

        validateNotBlankField(context, OlapBuilderMongoDbFindDataTable.COLLECTION, table.getCollection());

        OlapBuilderMongoDbDataTableWithPrototypeValidator.validateIsJson(context, OlapBuilderMongoDbFindDataTable.PROJECTION, table.getProjection());

        if (context.getSchemaDef().useFactPartitioning() && CdStringUtils.isNotNullAndNotBlank(table.getPartitionField()) && CdStringUtils.isNotNullAndNotBlank(table.getQuery()) && !table.hasQueryIncrLoadPart())
        {
            context.addError(OlapBuilderMongoDbFindDataTable.QUERY_INCRL_PART, OlapBuilderErrorCode.FIELD_IS_NULL, OlapBuilderMongoDbFindDataTable.QUERY_INCRL_PART.getName());

        }

        super.doValidate(context, dataSource, dataTable);
    }


}
