/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.mongodb.datatable.distinct;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdJson;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.mongodb.common.OlapBuilderMongoDbHelper;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbWithCollectionDataTable;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.bson.BsonValue;
import org.bson.Document;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@XmlRootElement(name = "mongoDB-distinct")
public class OlapBuilderMongoDbDistinctDataTable extends OlapBuilderMongoDbWithCollectionDataTable
{
    public static final CdProperty FIELD_NAME = new CdReadWriteProperty(OlapBuilderMongoDbDistinctDataTable.class, "fieldName", true);

    public static final CdProperty QUERY = new CdReadWriteProperty(OlapBuilderMongoDbDistinctDataTable.class, "query", false)
    {
        @Override
        public Class<?> getTypeForDefaultEditor()
        {
            return CdJson.class;
        }
    };

    public static final CdProperty BATCH_SIZE = new CdReadWriteProperty(GROUP_ADVANCED, OlapBuilderMongoDbDistinctDataTable.class, "batchSize", false);

    @XmlAttribute(name = "batchSize", required = false)
    @Nullable
    protected Integer batchSize;

    @XmlAttribute(name = "fieldName", required = false)
    @Nullable
    private String fieldName;

    @XmlAttribute(name = "query", required = false)
    @Nullable
    private String query;

    public OlapBuilderMongoDbDistinctDataTable()
    {
    }

    @Override
    public String getInternalFriendlyTypeName()
    {
        return "MongoDB Find Table";
    }

    @Override
    public OlapBuilderValidator<IOlapBuilderDataSource<OlapBuilderMongoDbConnection>, IOlapBuilderDataTableDef<OlapBuilderMongoDbConnection>> getValidator()
    {
        return new OlapBuilderMongoDbDistinctDataTableValidator();
    }

    @Override
    protected IOlapBuilderTableRowReader<OlapBuilderMongoDbConnection> doCreateFullTableRowReader(OlapBuilderContext context,
                                                                                                  OlapBuilderConnectionPool connectionPool,
                                                                                                  int maxRowCount)
    {
        return new OlapBuilderMongoDbDistinctTableRowReader(context, connectionPool, maxRowCount, this, "MongoDB " + getName() + ".find()");
    }

    @Override
    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, OlapBuilderMongoDbConnection connection, OlapBuilderErrorManager errorManager)
    {
        ArrayList<OlapBuilderDataColumn> list = new ArrayList<>();
        final BsonValue value = OlapBuilderMongoDbDistinctTableRowReader.firstNotNull(connection, this);
        OlapBuilderInputType type = OlapBuilderMongoDbHelper.toType(value);

        if (type == null)
        {
            return list;
        }

        OlapBuilderDataColumn column = new OlapBuilderDataColumn(type, value.getBsonType().name(), fieldName);
        list.add(column);
        return list;
    }

    @Override
    protected Document findOneForDiscoverColumns(OlapBuilderMongoDbConnection connection)
    {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Nullable
    public Integer getBatchSize()
    {
        return batchSize;
    }

    @Nullable
    public String getFieldName()
    {
        return fieldName;
    }

    @Nullable
    public String getQuery()
    {
        return query;
    }

    @Override
    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable)
    {
        if (super.isRefreshColumnOnUpdate(newTable))
        {
            return true;
        }

        final OlapBuilderMongoDbDistinctDataTable tableUpdate = (OlapBuilderMongoDbDistinctDataTable) newTable;

        return !Objects.equals(this.query, tableUpdate.query);
    }

}
