/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.mongodb.datatable.aggregate;

import com.iccube.bson.ic3BsonRow;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Aggregates;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTablePartitionKey;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbTableRowReader;
import org.bson.Document;
import org.bson.conversions.Bson;

import java.util.Collections;
import java.util.List;

public class OlapBuilderMongoDbAggregateTableRowReader extends OlapBuilderMongoDbTableRowReader<OlapBuilderMongoDbAggregateDataTable>
{
    public OlapBuilderMongoDbAggregateTableRowReader(OlapBuilderContext context,
                                                     OlapBuilderConnectionPool connectionPool,
                                                     int maxRowCount,
                                                     OlapBuilderMongoDbAggregateDataTable table,
                                                     String fullNameForEndUser, IOlapBuilderTablePartitionKey partitionKey)
    {
        super(context, connectionPool, maxRowCount, table, fullNameForEndUser);
        this.partitionKey = (OlapBuilderAbstractTablePartitionKey) partitionKey;
    }

    static Document first(OlapBuilderMongoDbConnection connection, OlapBuilderMongoDbAggregateDataTable table)
    {
        final MongoDatabase bd = connection.getMongoDataBase();
        final MongoCollection<Document> collection = bd.getCollection(table.getCollection());

        AggregateIterable<Document> aggregateQuery = collection.aggregate(toBsonList("aggr. pipeline", "BsonList", table.getPipeline()));
        if (table.getAllowDiskUse() != null)
        {
            aggregateQuery = aggregateQuery.allowDiskUse(table.getAllowDiskUse());
        }

        return aggregateQuery.first();
    }

    @Override
    public void doInit()
    {
        initConnection();

        final Comparable incrLoadMarker = context != null ? context.getIncrementalLoadMarker(table) : null;

        final List<Bson> pipeline;
        if (incrLoadMarker == null && partitionKey == null)
        {
            pipeline = toBsonList("aggr. pipeline", "BsonList", table.getPipeline());
        }
        else
        {
            if (!table.hasQueryIncrLoadPart())
            {
                final Bson filters = getColumnBasedFilter(incrLoadMarker);
                pipeline = Collections.singletonList(Aggregates.match(filters));
            }
            else
            {
                final String pipelineIncrLoad = table.getPipelineIncrLoad(incrLoadMarker, partitionKey == null ? null : partitionKeyForReplacement());
                pipeline = toBsonList("aggr. incr. pipeline", "BsonList", pipelineIncrLoad);
            }
        }

        final MongoCollection<Document> collection = getCollection(table.getCollection());
        AggregateIterable<ic3BsonRow> aggregateQuery = collection.aggregate(pipeline, ic3BsonRow.class);

        // batch size
        if (table.getBatchSize() != null)
        {
            aggregateQuery = aggregateQuery.batchSize(table.getBatchSize());
        }
        if (table.getAllowDiskUse() != null)
        {
            aggregateQuery = aggregateQuery.allowDiskUse(table.getAllowDiskUse());
        }
        result = aggregateQuery.iterator();
    }

}
