/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.mongodb.datatable.aggregate;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbTableColumnBuilder;
import org.bson.Document;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * Introduced while working on REPORTING visibility for MongoDB. We cannot reuse the ic3 BSON codec...
 */
public class OlapBuilderMongoDbAggregateExDataTable extends OlapBuilderMongoDbAggregateDataTable
{
    public OlapBuilderMongoDbAggregateExDataTable()
    {
    }

    public OlapBuilderMongoDbAggregateExDataTable(String name, String collection, @Nullable String jsonPrototype, String pipeline, @Nullable Boolean allowDiskUse, @Nullable Integer batchSize)
    {
        super(name, collection, jsonPrototype, pipeline, allowDiskUse, batchSize);
    }

    @Override
    protected IOlapBuilderTableRowReader<OlapBuilderMongoDbConnection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount)
    {
        return new OlapBuilderMongoDbAggregateExTableRowReader(
                context,
                connectionPool,
                maxRowCount,
                this,
                "MongoDB " + getName() + ".aggregate()"
        );
    }

    /**
     * Re-using the same code/logic as in the builder Aggregate table.
     */
    protected List<IOlapBuilderDataColumnDef> discoverAllColumns(Document document)
    {
        final List<IOlapBuilderDataColumnDef> cols;

        if (CdStringUtils.isNotNullAndNotBlank(jsonPrototype))
        {
            cols = discoverAllColumnsFromPrototype();
        }
        else
        {
            cols = OlapBuilderMongoDbTableColumnBuilder.discoverColumn(document);

        }

        setAllColumns(cols);
        setColumnsIndex();

        return cols;
    }

}
