/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.mongodb.datatable.aggregate;

import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbDataTableWithPrototypeValidator;

public class OlapBuilderMongoDbAggregateDataTableValidator extends OlapBuilderMongoDbDataTableWithPrototypeValidator
{
    public OlapBuilderMongoDbAggregateDataTableValidator()
    {
    }

    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderDataSource<OlapBuilderMongoDbConnection> dataSource, IOlapBuilderDataTableDef<OlapBuilderMongoDbConnection> dataTable)
    {
        final OlapBuilderMongoDbAggregateDataTable table = (OlapBuilderMongoDbAggregateDataTable) dataTable;

        validateNotNullField(context, OlapBuilderMongoDbAggregateDataTable.COLLECTION, table.getCollection());
        validateIsJsonList(context, OlapBuilderMongoDbAggregateDataTable.PIPELINE, table.getPipeline());

        super.doValidate(context, dataSource, dataTable);
    }

}
