/*
 * Copyright 2014 - 2018 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package com.iccube.bson;

import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;

public class ic3BsonRowBuilder4Test extends ic3BsonRowBuilder
{
    private final Map<String, Comparable> values;

    public ic3BsonRowBuilder4Test(Comparable[] rowValues)
    {
        super(rowValues);

        this.values = new HashMap<>();
    }

    @Override
    public void setValue(String fieldName, Comparable value)
    {
        values.put(fieldName, value);
    }

    @Override
    public @Nullable
    ic3BsonRowBuilder getForChild(String documentFieldName)
    {
        return this;
    }

    public Map<String, Comparable> getValues()
    {
        return values;
    }
}
