package com.iccube.bson;

import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import org.jetbrains.annotations.Nullable;

/**
 * Just a marker class for now
 *
 * MongoDB manages directly arrays in the decoder so we can directly implement de interface.
 */
public class ic3BsonRow implements IOlapBuilderTableRow
{
    private final Comparable[] values;

    public ic3BsonRow(Comparable[] values)
    {
        this.values = values;
    }

    public ic3BsonRow()
    {
        this.values = null;
    }

    @Override
    public @Nullable Comparable getJavaNativeDataValue(IOlapBuilderDataColumnDef columnDef)
    {
        return values == null ? null : values[columnDef.getIndex()];
    }
}
