/*
 * Copyright 2014 - 2018 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package com.iccube.bson.decoder;

import com.iccube.bson.ic3BsonBytesBuffer;
import com.iccube.bson.ic3BsonType;

public class ic3BsonDocumentDecoder implements ic3BsonDecoder
{
    public static void decodeContent(ic3BsonBytesBuffer array, ic3BsonObjectBuilder rowBuilder)
    {
        ic3BsonType childType;
        while ((childType = array.getType()) != ic3BsonType.END_OF_DOCUMENT)
        {
            final ic3BsonDecoder decoder = childType.getDecoder();
            decoder.decode(array, rowBuilder);
        }
    }

    @Override
    public void decodeValue(ic3BsonBytesBuffer array, ic3BsonObjectBuilder rowBuilder, String fieldName)
    {
        array.skip(4);
        decodeContent(array, rowBuilder);
    }

    @Override
    public void skipValue(ic3BsonBytesBuffer array)
    {
        int size = array.getInt() - 4;
        array.skip(size);
    }
}
